/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall;

import com.sonicwall.DNSSettings;
import com.sonicwall.NetExtender;
import com.sonicwall.Profile;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class NetExtenderControl
implements Runnable {
    public static final int NXSTATE_DISCONNECTED = 0;
    public static final int NXSTATE_CONNECTED = 1;
    public static final int NXSTATE_CONNECTING = 2;
    public static final int NXSTATE_DISCONNECTING = 3;
    public static final int NXSTATE_RECONNECTING = 4;
    public static final int NX_EXIT_SUCCESS = 0;
    public static final int NX_EXIT_FAILURE = 1;
    public static final int NX_EXIT_IPV6_PARSE_FAILURE = 2;
    public static final int NX_EXIT_SSL_INIT_FAILURE = 3;
    public static final int NX_EXIT_PPPD_FAILURE = 4;
    public static final int NX_EXIT_NO_ROUTES = 5;
    public static final int NX_EXIT_PPPD_PERMISSION_FAILURE = 6;
    public static final int NX_EXIT_SERVER_ERROR = 7;
    public static final int NX_EXIT_EPCCHECK_FAILURE = 8;
    private static final Logger logger = Logger.getLogger(NetExtenderControl.class.getName());
    NetExtender ownerNetExtender = NetExtender.getInstance();
    private static NetExtenderControl instance;
    int retVal = 0;

    native int launchNX(String var1);

    public native void onNxExit();

    public native void nxlog(int var1, String var2);

    public native void setUsername(String var1);

    public native void setPassword(String var1);

    public native void setDomain(String var1);

    public native void setDestination(String var1);

    public native void setSessionId(String var1);

    public native void setTrustCert(int var1);

    native int verifyConfig();

    native int disconnectNX();

    public native boolean isConnected();

    public native int getNetExtenderState();

    native boolean isAuthFailed();

    native String getAuthMessage();

    public native String getClientIPv6Addr();

    public native String getTxBytes();

    public native String getRxBytes();

    public native String getRoutes();

    public native DNSSettings getDnsSettings();

    native void registerNXControlClass(NetExtenderControl var1, boolean var2);

    private native String jni_getScriptPPPFile();

    public native Profile[] loadSavedProfiles() throws IOException;

    public void saveProfiles() throws IOException {
        this.saveProfiles(null);
    }

    public native void saveProfiles(Profile var1) throws IOException;

    public native void deleteAllSavedProfiles();

    public native int generateTsr(String var1) throws IOException;

    public native boolean sendPassChange(String var1, String var2, String var3, String var4, String var5, String[] var6);

    public native boolean fixPppdPermission();

    public native boolean isInstallNeeded();

    public native int getCopyrightYear();

    public native boolean isRunningInApplicationsDir();

    public native void verifyRootCAFile(boolean var1);

    public native boolean isUninstallAfterExit();

    public native boolean isExitAfterDisconnect();

    public native boolean isNoProfileCreate();

    public native boolean isAllowSavePassword();

    public native boolean isAllowSaveUser();

    public native int getPwdExpDays();

    public native boolean mayUserChangePassword();

    public native boolean isUninstallAfterExitPref();

    public native void setUninstallAfterExitPref(boolean var1);

    public native boolean isAutoReconnectPref();

    public native void setAutoReconnectPref(boolean var1);

    public native int getMtuPref();

    public native void setMtuPref(int var1);

    public native boolean isPppSyncPref();

    public native void setPppSyncPref(boolean var1);

    public native int getDnsModePref();

    public native void setDnsModePref(int var1);

    private static void loadJniLibrary() {
        String string = System.getProperty("path.separator");
        String string2 = System.mapLibraryName("NetExtender");
        logger.fine("Loading JNI library: " + string2);
        try {
            System.loadLibrary("NetExtender");
            logger.fine("JNI library loaded successfully.");
        }
        catch (Throwable throwable) {
            logger.fine("Could not find JNI library in java.library.path");
            String string3 = "/usr/lib/" + string2;
            logger.fine("Loading JNI library: " + string3);
            try {
                System.load(string3);
                logger.fine("JNI library loaded successfully.");
            }
            catch (Throwable throwable2) {
                Object object;
                logger.severe("Could not load " + string2);
                String string4 = System.getProperty("java.library.path");
                if (string4 != null) {
                    object = new String[]{};
                    logger.severe("Contents of java.library.path:");
                    object = string4.split(string);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        logger.severe("  " + object[i]);
                    }
                } else {
                    logger.severe("java.library.path is null");
                }
                logger.severe("Exiting NetExtender.");
                object = System.getProperty("line.separator");
                String string5 = "There was a problem loading the NetExtender JNI library." + (String)object + "Please reinstall NetExtender, and make sure you have a" + (String)object + "compatible version of Java installed.  SonicWALL recommends" + (String)object + "Sun Java 1.4 or higher.";
                logger.severe((String)object + string5 + (String)object + (String)object + "Press CTRL-C to exit");
                JOptionPane.showMessageDialog(null, string5, "NetExtender Error", 0);
                System.exit(1);
            }
        }
    }

    public static NetExtenderControl getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new NetExtenderControl();
        NetExtender.getInstance();
        NetExtender.initLogging2();
        logger.fine("NetExtenderControl: initialized ... ");
        return instance;
    }

    private NetExtenderControl() {
        this.registerNXControlClass(this, !System.getProperty("os.version").startsWith("10.4"));
    }

    public String getPPPFileLocation() {
        logger.fine("NetExtenderControl: Querying PPP_STATUS_SCRIPT location");
        return this.jni_getScriptPPPFile();
    }

    public void run() {
        logger.fine("NetExtenderControl: Launching NetExtender...");
        this.retVal = this.launchNX("");
        logger.fine("NetExtenderControl: NetExtender exited");
    }

    public int getRetVal() {
        return this.retVal;
    }

    public void notifyOfNXExit(int n, boolean bl) {
        logger.finer("notifyOfNXExit(" + n + ", " + bl + ")");
        String string = this.getAuthMessage();
        if (n == 0) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            if (string != null) {
                this.ownerNetExtender.displayErrorMessage(string);
            } else {
                this.ownerNetExtender.displayErrorMessage("NetExtender disconnected");
            }
        } else if (n == 8) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            this.ownerNetExtender.displayErrorMessage("Epc check failed");
        } else if (n == 4) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            this.ownerNetExtender.displayErrorMessage("Failed to connect - check log for details");
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "show_log"));
        } else if (n == 6) {
            if (NetExtender.isMacMode() && this.promptForMaintenance() && this.fixPppdPermission()) {
                bl = true;
            } else {
                this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
                this.ownerNetExtender.displayErrorMessage("Failed to connect - check log for details");
            }
        } else if (n == 5) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            this.ownerNetExtender.displayErrorMessage("Failed to connect - No routes found. Contact your administrator for assistance.");
        } else if (n == 7) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            if (string != null) {
                this.ownerNetExtender.displayErrorMessage(string);
            } else {
                this.ownerNetExtender.displayErrorMessage("Failed to connect - check log for details");
                this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "show_log"));
            }
        } else if (this.isAuthFailed()) {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "auth_failed"));
            int n2 = this.getPwdExpDays();
            if (n2 < 0 && this.mayUserChangePassword()) {
                this.ownerNetExtender.showPasswordExpirationWarning(n2);
            }
        } else {
            this.ownerNetExtender.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            if (string != null) {
                this.ownerNetExtender.displayErrorMessage(string);
            } else {
                this.ownerNetExtender.displayErrorMessage("Failed to connect");
            }
        }
        if (bl) {
            new Thread(){

                public void run() {
                    NetExtenderControl.this.ownerNetExtender.actionPerformed(new ActionEvent(this, 1001, "reconnect"));
                }
            }.start();
        }
    }

    public boolean promptForMaintenance() {
        int n = JOptionPane.showConfirmDialog(this.ownerNetExtender.mainFrame, "NetExtender needs to perform maintenance tasks.\nYou will need to enter your Mac administrator password in the next window.", "NetExtender Error", 2, 3);
        return n == 0;
    }

    public byte[] getPassFromGUI(String string) {
        String string2 = null;
        logger.finer("getPassFromGUI: tfmessage = " + string);
        string2 = this.ownerNetExtender.promptForPassword(string);
        logger.finer("password going back to net extender is " + (string2 == null ? "null" : "not null"));
        if (string2 != null) {
            return string2.getBytes();
        }
        return null;
    }

    public byte[] getRsaNewPinFromGUI(String string) {
        String string2 = null;
        logger.finer("getRsaNewPinFromGUI: tfmessage = " + string);
        string2 = this.ownerNetExtender.getRsaNewPin(string);
        logger.finer("RSA new PIN going back to net extender is " + (string2 == null ? "null" : "not null"));
        if (string2 != null) {
            return string2.getBytes();
        }
        return null;
    }

    public byte[] getRsaSysPinFromGUI(String string) {
        String string2 = null;
        logger.finer("getRsaSysPinFromGUI: tfmessage = " + string);
        string2 = this.ownerNetExtender.getRsaSysPin(string);
        logger.finer("RSA sys PIN reply going back to net extender is " + (string2 == null ? "null" : "not null"));
        if (string2 != null) {
            return string2.getBytes();
        }
        return null;
    }

    public byte[] getRsaNextTokenFromGUI(String string) {
        String string2 = null;
        logger.finer("getRsaNextTokenFromGUI: tfmessage = " + string);
        string2 = this.ownerNetExtender.getRsaNextToken(string);
        logger.finer("RSA next token result going back to net extender is " + (string2 == null ? "null" : "not null"));
        if (string2 != null) {
            return string2.getBytes();
        }
        return null;
    }

    public void showMessageBox(String string) {
        JOptionPane.showMessageDialog(this.ownerNetExtender.mainFrame, string);
    }

    public int getCertVerifyConfirmFromGUI(String string, byte[] byArray) {
        return this.ownerNetExtender.getCertVerifyConfirm(string, byArray);
    }

    static {
        NetExtenderControl.loadJniLibrary();
    }
}

