/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CertificateDetail
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private static final Logger logger = Logger.getLogger(CertificateDetail.class.getName());
    public static String CERT_FILE_PATH = "/tmp/virtualassist.pem";
    public static int MAX_NAME_LEN = 128;
    public static int MAX_LINE_LEN = 1024;
    private byte[] certDetail;
    private X509Certificate mCertificate = null;
    private JButton btOk;
    private JButton btCancel;
    private JButton btApply;
    private JTextArea txIssueToCN;
    private JTextArea txIssueToO;
    private JTextArea txIssueToOU;
    private JTextArea txIssueByCN;
    private JTextArea txIssueByO;
    private JTextArea txIssueByOU;
    private JTextArea txIssueToSN;
    private JTextArea txIssuedOn;
    private JTextArea txExpiredOn;
    private JTextArea txSHA256Fingerprint;
    private JTextArea txSHA1Fingerprint;
    public static final String CLOSE = "CLOSE";
    public static final int LINE_HEIGHT = 23;
    public static final int LINE_WIDTH = 520;
    public static final int LABEL_WIDTH = 160;
    public static final int INTERVAL_WIDTH = 40;

    public CertificateDetail(JFrame jFrame, String string, byte[] byArray) {
        super(jFrame, string, true);
        if (byArray.length > 0) {
            this.certDetail = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.certDetail, 0, byArray.length);
        } else {
            this.certDetail = null;
        }
        this.initComponents();
    }

    public CertificateDetail(JFrame jFrame, String string, X509Certificate x509Certificate) {
        super(jFrame, string, true);
        this.mCertificate = x509Certificate;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 2, 10, 0));
        Serializable serializable = (FlowLayout)jPanel.getLayout();
        ((FlowLayout)serializable).setAlignment(0);
        jPanel.setBackground(UIManager.getColor("Button.background"));
        this.contentPanel.add(jPanel);
        JLabel jLabel = new JLabel("This certificate has been verified for the following usages:");
        jLabel.setPreferredSize(new Dimension(520, 23));
        jLabel.setFont(new Font("Dialog", 1, 12));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 2, 5, 0));
        this.contentPanel.add(jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)jPanel3.getLayout();
        flowLayout.setAlignment(0);
        jPanel2.add(jPanel3);
        JLabel jLabel2 = new JLabel("Issued To");
        jLabel2.setPreferredSize(new Dimension(520, 23));
        jLabel2.setFont(new Font("Dialog", 1, 12));
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel();
        jPanel2.add(jPanel4);
        jPanel4.setLayout(new BorderLayout(0, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(40, 23));
        jPanel4.add((Component)jLabel3, "West");
        JPanel jPanel5 = new JPanel();
        jPanel4.add(jPanel5);
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JPanel jPanel6 = new JPanel();
        jPanel5.add(jPanel6);
        jPanel6.setAlignmentY(1.0f);
        jPanel6.setAlignmentX(1.0f);
        jPanel6.setLayout(new BorderLayout(0, 0));
        JLabel jLabel4 = new JLabel("Common Name (CN)");
        jLabel4.setPreferredSize(new Dimension(160, 23));
        jLabel4.setFont(new Font("Dialog", 0, 12));
        jPanel6.add((Component)jLabel4, "West");
        this.txIssueToCN = new JTextArea();
        this.txIssueToCN.setText("");
        this.txIssueToCN.setFont(new Font("Dialog", 0, 12));
        this.txIssueToCN.setBackground(UIManager.getColor("Button.background"));
        this.txIssueToCN.setLineWrap(true);
        this.txIssueToCN.setEditable(false);
        this.txIssueToCN.setWrapStyleWord(true);
        this.txIssueToCN.setPreferredSize(new Dimension(160, 23));
        this.txIssueToCN.setMaximumSize(new Dimension(160, 23));
        jPanel6.add((Component)this.txIssueToCN, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setAlignmentY(1.0f);
        jPanel7.setAlignmentX(1.0f);
        jPanel5.add(jPanel7);
        jPanel7.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel7.setLayout(new BorderLayout(0, 0));
        JLabel jLabel5 = new JLabel("Organization (O)");
        jLabel5.setPreferredSize(new Dimension(160, 23));
        jLabel5.setFont(new Font("Dialog", 0, 12));
        jPanel7.add((Component)jLabel5, "West");
        this.txIssueToO = new JTextArea();
        this.txIssueToO.setText("a");
        this.txIssueToO.setLineWrap(true);
        this.txIssueToO.setEditable(false);
        this.txIssueToO.setWrapStyleWord(true);
        this.txIssueToO.setFont(new Font("Dialog", 0, 12));
        this.txIssueToO.setBackground(UIManager.getColor("Button.background"));
        this.txIssueToO.setPreferredSize(new Dimension(160, 23));
        this.txIssueToO.setMaximumSize(new Dimension(160, 23));
        jPanel7.add((Component)this.txIssueToO, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setAlignmentY(1.0f);
        jPanel8.setAlignmentX(1.0f);
        jPanel5.add(jPanel8);
        jPanel8.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel8.setLayout(new BorderLayout(0, 0));
        JLabel jLabel6 = new JLabel("Organizational Unit (OU)");
        jLabel6.setPreferredSize(new Dimension(160, 23));
        jLabel6.setFont(new Font("Dialog", 0, 12));
        jPanel8.add((Component)jLabel6, "West");
        this.txIssueToOU = new JTextArea();
        this.txIssueToOU.setText("");
        this.txIssueToOU.setLineWrap(true);
        this.txIssueToOU.setEditable(false);
        this.txIssueToOU.setWrapStyleWord(true);
        this.txIssueToOU.setFont(new Font("Dialog", 0, 12));
        this.txIssueToOU.setBackground(UIManager.getColor("Button.background"));
        this.txIssueToOU.setPreferredSize(new Dimension(160, 23));
        this.txIssueToOU.setMaximumSize(new Dimension(160, 23));
        jPanel8.add((Component)this.txIssueToOU, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel5.add(jPanel9);
        jPanel9.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel9.setAlignmentY(1.0f);
        jPanel9.setAlignmentX(1.0f);
        jPanel9.setLayout(new BorderLayout(0, 0));
        JLabel jLabel7 = new JLabel("Serial Number");
        jLabel7.setPreferredSize(new Dimension(160, 23));
        jLabel7.setFont(new Font("Dialog", 0, 12));
        jPanel9.add((Component)jLabel7, "West");
        this.txIssueToSN = new JTextArea();
        this.txIssueToSN.setText("");
        this.txIssueToSN.setLineWrap(true);
        this.txIssueToSN.setEditable(false);
        this.txIssueToSN.setWrapStyleWord(true);
        this.txIssueToSN.setFont(new Font("Dialog", 0, 12));
        this.txIssueToSN.setBackground(UIManager.getColor("Button.background"));
        this.txIssueToSN.setPreferredSize(new Dimension(160, 23));
        this.txIssueToSN.setMaximumSize(new Dimension(160, 23));
        jPanel9.add((Component)this.txIssueToSN, "Center");
        JPanel jPanel10 = new JPanel();
        this.contentPanel.add(jPanel10);
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        JPanel jPanel11 = new JPanel();
        FlowLayout flowLayout2 = (FlowLayout)jPanel11.getLayout();
        flowLayout2.setAlignment(0);
        jPanel10.add(jPanel11);
        JLabel jLabel8 = new JLabel("Issued By");
        jLabel8.setPreferredSize(new Dimension(520, 23));
        jLabel8.setFont(new Font("Dialog", 1, 12));
        jPanel11.add(jLabel8);
        JPanel jPanel12 = new JPanel();
        jPanel10.add(jPanel12);
        jPanel12.setLayout(new BorderLayout(0, 0));
        JLabel jLabel9 = new JLabel();
        jLabel9.setPreferredSize(new Dimension(40, 23));
        jPanel12.add((Component)jLabel9, "West");
        JPanel jPanel13 = new JPanel();
        jPanel12.add((Component)jPanel13, "Center");
        jPanel13.setLayout(new BoxLayout(jPanel13, 1));
        JPanel jPanel14 = new JPanel();
        jPanel13.add(jPanel14);
        jPanel14.setLayout(new BorderLayout(0, 0));
        JLabel jLabel10 = new JLabel("Common Name (CN)");
        jLabel10.setPreferredSize(new Dimension(160, 23));
        jLabel10.setFont(new Font("Dialog", 0, 12));
        jPanel14.add((Component)jLabel10, "West");
        this.txIssueByCN = new JTextArea();
        this.txIssueByCN.setText("");
        this.txIssueByCN.setLineWrap(true);
        this.txIssueByCN.setEditable(false);
        this.txIssueByCN.setWrapStyleWord(true);
        this.txIssueByCN.setFont(new Font("Dialog", 0, 12));
        this.txIssueByCN.setBackground(UIManager.getColor("Button.background"));
        this.txIssueByCN.setPreferredSize(new Dimension(160, 23));
        this.txIssueByCN.setMaximumSize(new Dimension(160, 23));
        jPanel14.add((Component)this.txIssueByCN, "Center");
        JPanel jPanel15 = new JPanel();
        jPanel13.add(jPanel15);
        jPanel15.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel15.setLayout(new BorderLayout(0, 0));
        JLabel jLabel11 = new JLabel("Organization (O)");
        jLabel11.setPreferredSize(new Dimension(160, 23));
        jLabel11.setFont(new Font("Dialog", 0, 12));
        jPanel15.add((Component)jLabel11, "West");
        this.txIssueByO = new JTextArea();
        this.txIssueByO.setText("");
        this.txIssueByO.setLineWrap(true);
        this.txIssueByO.setEditable(false);
        this.txIssueByO.setWrapStyleWord(true);
        this.txIssueByO.setFont(new Font("Dialog", 0, 12));
        this.txIssueByO.setBackground(UIManager.getColor("Button.background"));
        this.txIssueByO.setPreferredSize(new Dimension(160, 23));
        this.txIssueByO.setMaximumSize(new Dimension(160, 23));
        jPanel15.add((Component)this.txIssueByO, "Center");
        JPanel jPanel16 = new JPanel();
        jPanel13.add(jPanel16);
        jPanel16.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel16.setLayout(new BorderLayout(0, 0));
        JLabel jLabel12 = new JLabel("Organizational Unit (OU)");
        jLabel12.setPreferredSize(new Dimension(160, 23));
        jLabel12.setFont(new Font("Dialog", 0, 12));
        jPanel16.add((Component)jLabel12, "West");
        this.txIssueByOU = new JTextArea();
        this.txIssueByOU.setText("");
        this.txIssueByOU.setLineWrap(true);
        this.txIssueByOU.setEditable(false);
        this.txIssueByOU.setWrapStyleWord(true);
        this.txIssueByOU.setFont(new Font("Dialog", 0, 12));
        this.txIssueByOU.setBackground(UIManager.getColor("Button.background"));
        this.txIssueByOU.setPreferredSize(new Dimension(160, 23));
        this.txIssueByOU.setMaximumSize(new Dimension(160, 23));
        jPanel16.add((Component)this.txIssueByOU, "Center");
        JPanel jPanel17 = new JPanel();
        this.contentPanel.add(jPanel17);
        jPanel17.setLayout(new BoxLayout(jPanel17, 1));
        JPanel jPanel18 = new JPanel();
        FlowLayout flowLayout3 = (FlowLayout)jPanel18.getLayout();
        flowLayout3.setAlignment(0);
        jPanel17.add(jPanel18);
        JLabel jLabel13 = new JLabel("Validity Period");
        jLabel13.setPreferredSize(new Dimension(520, 23));
        jPanel18.add(jLabel13);
        jLabel13.setFont(new Font("Dialog", 1, 12));
        JPanel jPanel19 = new JPanel();
        jPanel17.add(jPanel19);
        jPanel19.setLayout(new BorderLayout(0, 0));
        JLabel jLabel14 = new JLabel();
        jLabel14.setPreferredSize(new Dimension(40, 23));
        jPanel19.add((Component)jLabel14, "West");
        JPanel jPanel20 = new JPanel();
        jPanel19.add((Component)jPanel20, "Center");
        jPanel20.setLayout(new BoxLayout(jPanel20, 1));
        JPanel jPanel21 = new JPanel();
        jPanel20.add(jPanel21);
        jPanel21.setLayout(new BorderLayout(0, 0));
        JLabel jLabel15 = new JLabel("Issued On");
        jLabel15.setPreferredSize(new Dimension(160, 23));
        jLabel15.setFont(new Font("Dialog", 0, 12));
        jPanel21.add((Component)jLabel15, "West");
        this.txIssuedOn = new JTextArea();
        this.txIssuedOn.setText("");
        this.txIssuedOn.setLineWrap(true);
        this.txIssuedOn.setEditable(false);
        this.txIssuedOn.setWrapStyleWord(true);
        this.txIssuedOn.setFont(new Font("Dialog", 0, 12));
        this.txIssuedOn.setBackground(UIManager.getColor("Button.background"));
        this.txIssuedOn.setPreferredSize(new Dimension(160, 23));
        this.txIssuedOn.setMaximumSize(new Dimension(160, 23));
        jPanel21.add((Component)this.txIssuedOn, "Center");
        JPanel jPanel22 = new JPanel();
        jPanel20.add(jPanel22);
        jPanel22.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel22.setLayout(new BorderLayout(0, 0));
        JLabel jLabel16 = new JLabel("Expires On");
        jLabel16.setPreferredSize(new Dimension(160, 23));
        jLabel16.setFont(new Font("Dialog", 0, 12));
        jPanel22.add((Component)jLabel16, "West");
        this.txExpiredOn = new JTextArea();
        this.txExpiredOn.setText("");
        this.txExpiredOn.setLineWrap(true);
        this.txExpiredOn.setEditable(false);
        this.txExpiredOn.setWrapStyleWord(true);
        this.txExpiredOn.setFont(new Font("Dialog", 0, 12));
        this.txExpiredOn.setBackground(UIManager.getColor("Button.background"));
        this.txExpiredOn.setPreferredSize(new Dimension(160, 23));
        this.txExpiredOn.setMaximumSize(new Dimension(160, 23));
        jPanel22.add((Component)this.txExpiredOn, "Center");
        JPanel jPanel23 = new JPanel();
        this.contentPanel.add(jPanel23);
        jPanel23.setLayout(new BoxLayout(jPanel23, 1));
        JPanel jPanel24 = new JPanel();
        FlowLayout flowLayout4 = (FlowLayout)jPanel24.getLayout();
        flowLayout4.setAlignment(0);
        jPanel23.add(jPanel24);
        JLabel jLabel17 = new JLabel("Fingerprints");
        jLabel17.setPreferredSize(new Dimension(520, 23));
        jLabel17.setFont(new Font("Dialog", 1, 12));
        jPanel24.add(jLabel17);
        JPanel jPanel25 = new JPanel();
        jPanel23.add(jPanel25);
        jPanel25.setLayout(new BorderLayout(0, 0));
        JLabel jLabel18 = new JLabel();
        jLabel18.setPreferredSize(new Dimension(40, 23));
        jPanel25.add((Component)jLabel18, "West");
        JPanel jPanel26 = new JPanel();
        jPanel25.add((Component)jPanel26, "Center");
        jPanel26.setLayout(new BoxLayout(jPanel26, 1));
        JPanel jPanel27 = new JPanel();
        jPanel26.add(jPanel27);
        jPanel27.setLayout(new BorderLayout(0, 0));
        JLabel jLabel19 = new JLabel("SHA-256 Fingerprint");
        jLabel19.setPreferredSize(new Dimension(160, 46));
        jLabel19.setFont(new Font("Dialog", 0, 12));
        this.txSHA256Fingerprint = new JTextArea();
        this.txSHA256Fingerprint.setText("");
        this.txSHA256Fingerprint.setLineWrap(true);
        this.txSHA256Fingerprint.setEditable(false);
        this.txSHA256Fingerprint.setWrapStyleWord(true);
        this.txSHA256Fingerprint.setFont(new Font("Dialog", 0, 12));
        this.txSHA256Fingerprint.setBackground(UIManager.getColor("Button.background"));
        this.txSHA256Fingerprint.setPreferredSize(new Dimension(160, 23));
        this.txSHA256Fingerprint.setMaximumSize(new Dimension(160, 23));
        JPanel jPanel28 = new JPanel();
        jPanel26.add(jPanel28);
        jPanel28.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel28.setLayout(new BorderLayout(0, 0));
        JLabel jLabel20 = new JLabel("SHA-1 Fingerprint");
        jLabel20.setPreferredSize(new Dimension(160, 46));
        jLabel20.setFont(new Font("Dialog", 0, 12));
        jPanel28.add((Component)jLabel20, "West");
        this.txSHA1Fingerprint = new JTextArea();
        this.txSHA1Fingerprint.setText("");
        this.txSHA1Fingerprint.setLineWrap(true);
        this.txSHA1Fingerprint.setEditable(false);
        this.txSHA1Fingerprint.setWrapStyleWord(true);
        this.txSHA1Fingerprint.setFont(new Font("Dialog", 0, 12));
        this.txSHA1Fingerprint.setBackground(UIManager.getColor("Button.background"));
        this.txSHA1Fingerprint.setPreferredSize(new Dimension(160, 23));
        this.txSHA1Fingerprint.setMaximumSize(new Dimension(160, 23));
        jPanel28.add(this.txSHA1Fingerprint);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        serializable = new JButton("Close");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificateDetail.this.setVisible(false);
                CertificateDetail.this.dispose();
            }
        });
        ((AbstractButton)serializable).setActionCommand(CLOSE);
        jPanel.add((Component)serializable);
        this.getRootPane().setDefaultButton((JButton)serializable);
    }

    private void updatePanel() {
        if (null != this.certDetail) {
            int n = 0;
            while (this.certDetail[MAX_NAME_LEN * 20 + MAX_LINE_LEN * 2 + MAX_NAME_LEN + n++] != 0) {
            }
            this.txIssuedOn.setText(new String(this.certDetail, MAX_NAME_LEN * 20 + MAX_LINE_LEN * 2 + MAX_NAME_LEN, --n < 128 ? n : 128));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 20 + MAX_LINE_LEN * 2 + n++] != 0) {
            }
            this.txExpiredOn.setText(new String(this.certDetail, MAX_NAME_LEN * 20 + MAX_LINE_LEN * 2, --n < 128 ? n : 128));
            n = 0;
            while (this.certDetail[n++] != 0) {
            }
            this.txIssueToCN.setText(new String(this.certDetail, 0, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 6 + n++] != 0) {
            }
            this.txIssueToO.setText(new String(this.certDetail, MAX_NAME_LEN * 6, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 8 + n++] != 0) {
            }
            this.txIssueToOU.setText(new String(this.certDetail, MAX_NAME_LEN * 8, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 20 + n++] != 0) {
            }
            this.txIssueToSN.setText(new String(this.certDetail, MAX_NAME_LEN * 20, --n < MAX_LINE_LEN ? n : MAX_LINE_LEN));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 10 + n++] != 0) {
            }
            this.txIssueByCN.setText(new String(this.certDetail, MAX_NAME_LEN * 10, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 16 + n++] != 0) {
            }
            this.txIssueByO.setText(new String(this.certDetail, MAX_NAME_LEN * 16, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 18 + n++] != 0) {
            }
            this.txIssueByOU.setText(new String(this.certDetail, MAX_NAME_LEN * 18, --n < 256 ? n : 256));
            n = 0;
            while (this.certDetail[MAX_NAME_LEN * 20 + MAX_LINE_LEN + n++] != 0) {
            }
            this.txSHA256Fingerprint.setText(new String(this.certDetail, MAX_NAME_LEN * 20 + MAX_LINE_LEN, --n < MAX_LINE_LEN ? n : MAX_LINE_LEN));
            this.txSHA1Fingerprint.setText(new String(this.certDetail, MAX_NAME_LEN * 20 + MAX_LINE_LEN, n < MAX_LINE_LEN ? n : MAX_LINE_LEN));
        } else if (null != this.mCertificate) {
            String[] stringArray = CertificateDetail.getCertificateFields(this.mCertificate.getIssuerX500Principal().toString());
            String[] stringArray2 = CertificateDetail.getCertificateFields(this.mCertificate.getSubjectX500Principal().toString());
            this.txIssuedOn.setText(this.mCertificate.getNotBefore().toString());
            this.txExpiredOn.setText(this.mCertificate.getNotAfter().toString());
            this.txIssueToCN.setText(stringArray2[1] != null ? stringArray2[1] : "");
            this.txIssueToO.setText(stringArray2[3] != null ? stringArray2[3] : "");
            this.txIssueToOU.setText(stringArray2[2] != null ? stringArray2[2] : "");
            this.txIssueToSN.setText(this.mCertificate.getSerialNumber().toString(16));
            this.txIssueByCN.setText(stringArray[1] != null ? stringArray[1] : "");
            this.txIssueByO.setText(stringArray[3] != null ? stringArray[3] : "");
            this.txIssueByOU.setText(stringArray[2] != null ? stringArray[2] : "");
            this.txSHA256Fingerprint.setText(CertificateDetail.getThumbPrint(this.mCertificate));
            this.txSHA1Fingerprint.setText(CertificateDetail.getThumbPrint(this.mCertificate));
        }
    }

    public static String[] getCertificateFields(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Object object = new StringTokenizer(string, ",", false);
        if (object != null) {
            while (((StringTokenizer)object).hasMoreElements()) {
                StringTokenizer stringTokenizer;
                String string2 = (String)((StringTokenizer)object).nextElement();
                if (string2 == null || (stringTokenizer = new StringTokenizer(string2 = string2.trim(), "=", false)) == null || !stringTokenizer.hasMoreElements()) continue;
                String string3 = (String)stringTokenizer.nextElement();
                String string4 = null;
                if (string3 == null) continue;
                string3 = string3.trim();
                if (stringTokenizer.hasMoreElements()) {
                    string4 = (String)stringTokenizer.nextElement();
                }
                if (string4 == null || string4.trim().equals("")) continue;
                if (string3.equals("EMAILADDRESS")) {
                    stringBuffer2.append(string4 + ",");
                    continue;
                }
                if (string3.equals("CN")) {
                    stringBuffer.append(string4 + ",");
                    continue;
                }
                if (string3.equals("OU")) {
                    stringBuffer3.append(string4 + ",");
                    continue;
                }
                if (string3.equals("O")) {
                    stringBuffer4.append(string4 + ",");
                    continue;
                }
                if (string3.equals("L")) {
                    stringBuffer5.append(string4 + ",");
                    continue;
                }
                if (string3.equals("ST")) {
                    stringBuffer6.append(string4 + ",");
                    continue;
                }
                if (!string3.equals("C")) continue;
                stringBuffer7.append(string4 + ",");
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer2.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer3.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer4.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer5.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer6.toString()));
        ((ArrayList)object).add(CertificateDetail.removeLastComma(stringBuffer7.toString()));
        return ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
    }

    private static String removeLastComma(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        string = string.charAt(string.length() - 1) == ',' ? string.substring(0, string.length() - 1) : string.trim();
        String string2 = null;
        string2 = string.trim().equals("") ? null : string.trim();
        return string2;
    }

    public static String getThumbPrint(X509Certificate x509Certificate) {
        MessageDigest messageDigest = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
            byArray = x509Certificate.getEncoded();
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return CertificateDetail.hexify(byArray2);
    }

    public static String hexify(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
            stringBuffer.append(cArray[byArray[i] & 0xF]);
            if (++n == byArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static void ShowCertificateDetail(JFrame jFrame, String string, byte[] byArray) {
        CertificateDetail certificateDetail = new CertificateDetail(null, string, byArray);
        certificateDetail.updatePanel();
        certificateDetail.setDefaultCloseOperation(2);
        certificateDetail.pack();
        certificateDetail.setLocationRelativeTo(jFrame);
        certificateDetail.setVisible(true);
    }

    public static void ShowCertificateDetail(JFrame jFrame, String string, X509Certificate x509Certificate) {
        CertificateDetail certificateDetail = new CertificateDetail(null, string, x509Certificate);
        certificateDetail.updatePanel();
        certificateDetail.setDefaultCloseOperation(2);
        certificateDetail.pack();
        certificateDetail.setLocationRelativeTo(jFrame);
        certificateDetail.setVisible(true);
    }
}

