/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.NetExtender;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogDialog
extends JDialog
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    public static final String CLOSE_LOG = "close_log";
    public static final String CLEAR_LOG = "clear_log";
    public static final String COPY_LOG = "copy_log";
    JPanel logPanel;
    JPanel logButtonPanel;
    JScrollPane logScrollPane;
    JTextArea logTextArea;
    JButton closeLogButton;
    JButton clearLogButton;
    JButton copyLogButton;
    private String logFilePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".netExtender.log";
    private File logFile = new File(this.logFilePath);
    private static final Logger logger = Logger.getLogger(LogDialog.class.getName());

    public LogDialog() {
        this.logPanel = new JPanel();
        this.logButtonPanel = new JPanel();
        this.logPanel.setLayout(new GridLayout(1, 1));
        this.logButtonPanel.setLayout(new GridLayout(1, 2));
        this.setSize(800, 400);
        this.setTitle("NetExtender Log (" + this.logFilePath + ")");
        this.logTextArea = new JTextArea();
        this.logTextArea.setSize(600, 300);
        this.logTextArea.setEditable(false);
        if (NetExtender.isMacMode()) {
            this.logTextArea.setFont(new Font("Monaco", 0, 12));
        } else {
            this.logTextArea.setFont(new Font("Monospaced", 0, this.logTextArea.getFont().getSize()));
        }
        this.logScrollPane = new JScrollPane(this.logTextArea);
        this.logScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            int maximum = 0;

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (adjustmentEvent.getAdjustable().getMaximum() != this.maximum) {
                    this.maximum = adjustmentEvent.getAdjustable().getMaximum();
                    adjustmentEvent.getAdjustable().setValue(this.maximum);
                }
            }
        });
        this.closeLogButton = new JButton("Close");
        this.closeLogButton.setActionCommand(CLOSE_LOG);
        this.closeLogButton.addActionListener(this);
        this.clearLogButton = new JButton("Clear Log");
        this.clearLogButton.setActionCommand(CLEAR_LOG);
        this.clearLogButton.addActionListener(this);
        this.copyLogButton = new JButton("Copy Log");
        this.copyLogButton.setActionCommand(COPY_LOG);
        this.copyLogButton.addActionListener(this);
        this.logPanel.add(this.logScrollPane);
        this.logPanel.revalidate();
        this.logButtonPanel.add((Component)this.clearLogButton, "West");
        this.logButtonPanel.add((Component)this.copyLogButton, "Center");
        this.logButtonPanel.add((Component)this.closeLogButton, "East");
        this.getContentPane().add((Component)this.logPanel, "Center");
        this.getContentPane().add((Component)this.logButtonPanel, "South");
        new Thread(new LogReader()).start();
    }

    public void log(String string) {
        this.logTextArea.append(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CLOSE_LOG.equals(string)) {
            logger.fine("Received CLOSE_LOG");
            this.setVisible(false);
        } else if (CLEAR_LOG.equals(string)) {
            logger.fine("Received CLEAR_LOG");
            this.logTextArea.setText("");
            try {
                FileWriter fileWriter = new FileWriter(this.logFile);
                fileWriter.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (COPY_LOG.equals(string)) {
            logger.fine("Received COPY_LOG");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.logTextArea.getText());
            clipboard.setContents(stringSelection, this);
        }
    }

    public JTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private class LogReader
    implements Runnable {
        private LogReader() {
        }

        public void run() {
            char[] cArray = new char[1024];
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            while (true) {
                if ((l = LogDialog.this.logFile.length()) == l2) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    FileReader fileReader = new FileReader(LogDialog.this.logFile);
                    if (l < l2) {
                        l2 = 0L;
                    }
                    fileReader.skip(l2);
                    while (fileReader.ready() && (n = fileReader.read(cArray, 0, 1024)) > 0) {
                        LogDialog.this.log(String.valueOf(cArray, 0, n));
                        l2 += (long)n;
                    }
                    fileReader.close();
                    continue;
                }
                catch (IOException iOException) {
                    LogDialog.this.log("Error reading log file: " + iOException);
                    continue;
                }
                break;
            }
        }
    }
}

