/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall;

import com.sonicwall.MacHandler;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.Profile;
import com.sonicwall.gui.AboutDialog;
import com.sonicwall.gui.CertificateDialog;
import com.sonicwall.gui.LogDialog;
import com.sonicwall.gui.NetExtenderRootPanel;
import com.sonicwall.gui.PasswordDialog;
import com.sonicwall.gui.PreferencesDialog;
import com.sonicwall.gui.RsaNewPinDialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class NetExtender
implements ActionListener {
    public static final String DISCONNECT = "disconnect";
    public static final String CONNECTING = "connecting";
    public static final String CONNECTED = "connected";
    public static final String AUTH_FAILED = "auth_failed";
    public static final String SHOW_LOG = "show_log";
    public static final String GENERATE_TSR = "generate_tsr";
    public static final String DISCONNECTING = "disconnecting";
    public static final String DISCONNECTED = "disconnected";
    public static final String RECONNECT = "reconnect";
    public static final String PREFERENCES = "preferences";
    public static final String ABOUT = "about";
    public static final String QUIT = "quit";
    public static final String SAVE_NAME_AND_PASS = "Save name and password (if allowed)";
    public static final String SAVE_NAME_ONLY = "Save username only (if allowed)";
    public static final String SAVE_NOTHING = "Do not save profile";
    public static final String DEBUG_SHOW_DISCONNECTED_PANEL = "debug_show_disconnected_panel";
    public static final String DEBUG_SHOW_CONNECTING_PANEL = "debug_show_connecting_panel";
    public static final String DEBUG_SHOW_CONNECTED_PANEL = "debug_show_connected_panel";
    public static final String DEBUG_SHOW_DISCONNECTING_PANEL = "debug_show_disconnecting_panel";
    public static final String DEBUG_666 = "debug_666";
    public static final String DESTINATION_FIELD_NAME = "dstField";
    public static final String CLIENT_IP_FILE = "/etc/ppp/sslvpn.clientip";
    private static String version;
    private static Logger logger;
    private static boolean macMode;
    private static Image nxIcon;
    private String pppStatusFile;
    JFrame mainFrame;
    JPanel mainPanel;
    NetExtenderRootPanel rootPanel;
    LogDialog logDialog;
    AboutDialog aboutDialog;
    PreferencesDialog preferencesDialog;
    JButton showLogButton;
    JButton showRoutesButton;
    JButton showOptionsButton;
    JMenuBar menuBar;
    JMenu windowMenu;
    JMenuItem mLog;
    JMenuItem mGenerateTsr;
    JMenu debugMenu;
    JMenuItem mShowDisconnectedPanel;
    JMenuItem mShowConnectingPanel;
    JMenuItem mShowConnectedPanel;
    JMenuItem mShowDisconnectingPanel;
    JMenuItem mDebug666;
    private String destinationIp;
    private String username;
    private String password;
    private String domainValue;
    private String sessionId;
    private String profileSavePreference = "Save name and password (if allowed)";
    int connectingCounter = 0;
    Thread nxThread;
    private NetExtenderControl nxControl;
    private static NetExtender instance;
    private boolean autoReconnectPref = true;
    private boolean uninstallOnExitPref = false;

    public static NetExtender getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new NetExtender();
        return instance;
    }

    private NetExtender() {
    }

    public void go() {
        try {
            NetExtender.readVersion();
            logger.info("NetExtender version " + NetExtender.getVersion());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error reading version number", exception);
            version = "(version unknown)";
        }
        try {
            MacHandler.init();
            macMode = true;
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.config("Mac classes not found; Mac-specific features will be disabled");
        }
        catch (Exception exception) {
            logger.config("Mac classes not found; Mac-specific features will be disabled");
        }
        this.nxControl = NetExtenderControl.getInstance();
        if (macMode && !this.nxControl.isRunningInApplicationsDir()) {
            JOptionPane.showMessageDialog(null, "Please copy NetExtender to your Applications folder and run it from there.", "NetExtender Error", 1);
            System.exit(1);
        }
        this.mainFrame = new JFrame("NetExtender");
        this.mainFrame.setIconImage(NetExtender.loadIcon());
        if (macMode) {
            this.mainFrame.setSize(new Dimension(600, 470));
        } else {
            this.mainFrame.setSize(new Dimension(600, 520));
        }
        this.mainFrame.setResizable(false);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NetExtender.this.actionPerformed(new ActionEvent(NetExtender.this.mainFrame, 1001, NetExtender.QUIT));
            }
        });
        this.initMenus();
        this.mainFrame.setLocationRelativeTo(null);
        this.initDialogs();
        this.pppStatusFile = this.nxControl.getPPPFileLocation();
        logger.fine("PPP status file is at " + this.pppStatusFile);
        this.rootPanel = new NetExtenderRootPanel(this.mainFrame);
        this.mainFrame.setContentPane(this.rootPanel);
        this.rootPanel.showGui("GUI_DISCONNECTED");
        this.mainFrame.setVisible(true);
        logger.fine("sessionId = " + this.sessionId);
        if (this.sessionId != null) {
            logger.finer("nxControl.setDestination(\"" + this.destinationIp + "\")");
            this.nxControl.setDestination(this.destinationIp);
            logger.finer("nxControl.setSessionId(\"" + this.sessionId + "\")");
            this.nxControl.setSessionId(this.sessionId);
            logger.finer("nxControl.setUsername(\"" + this.username + "\")");
            this.nxControl.setUsername(this.username);
            logger.finer("nxControl.setPassword(\"DoNotSaveMe\")");
            this.nxControl.setPassword("DoNotSaveMe");
            logger.finer("nxControl.setDomain(\"" + this.domainValue + "\")");
            this.nxControl.setDomain(this.domainValue);
            logger.info("Trying to auto-connect...");
            this.setProfileSavePreference(SAVE_NAME_ONLY);
            this.actionPerformed(new ActionEvent(this, 1001, CONNECTING));
        }
    }

    private static void readVersion() throws FileNotFoundException, IOException {
        ClassLoader classLoader = NetExtender.class.getClassLoader();
        Properties properties = new Properties();
        try {
            properties.load(classLoader.getResourceAsStream("version.properties"));
        }
        catch (IOException iOException) {
            properties.load(new FileInputStream("version.properties"));
        }
        version = properties.getProperty("VERSION");
    }

    public static Image loadIcon() {
        if (nxIcon == null) {
            nxIcon = NetExtender.loadImage("img/nx32.png");
        }
        return nxIcon;
    }

    public static Image loadImage(String string) {
        logger.finer("loadIcon: filename = " + string);
        ClassLoader classLoader = NetExtender.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        Image image = null;
        logger.finer("loadIcon: iconUrl = " + uRL);
        image = uRL != null ? Toolkit.getDefaultToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().getImage(string);
        return image;
    }

    private void initDialogs() {
        this.logDialog = new LogDialog();
        this.logDialog.setLocationRelativeTo(this.mainFrame);
        this.aboutDialog = new AboutDialog(this.mainFrame);
        this.aboutDialog.setLocationRelativeTo(this.mainFrame);
        this.preferencesDialog = new PreferencesDialog(this.mainFrame);
        this.preferencesDialog.setLocationRelativeTo(this.mainFrame);
    }

    private void initMenus() {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        this.menuBar = new JMenuBar();
        if (!macMode) {
            jMenuItem2 = new JMenu("NetExtender");
            jMenuItem2.setMnemonic(78);
            this.menuBar.add((JMenu)jMenuItem2);
            jMenuItem = new JMenuItem("Exit", 88);
            jMenuItem.setActionCommand(QUIT);
            jMenuItem.addActionListener(this);
            ((JMenu)jMenuItem2).add(jMenuItem);
        }
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic(87);
        this.menuBar.add(this.windowMenu);
        this.mLog = new JMenuItem("Log", 76);
        this.mLog.setActionCommand(SHOW_LOG);
        this.mLog.addActionListener(this);
        this.windowMenu.add(this.mLog);
        if (!macMode) {
            jMenuItem2 = new JMenuItem("Preferences", 80);
            jMenuItem2.setActionCommand(PREFERENCES);
            jMenuItem2.addActionListener(this);
            this.windowMenu.add(jMenuItem2);
        }
        jMenuItem2 = new JMenu("Help");
        jMenuItem2.setMnemonic(72);
        this.menuBar.add((JMenu)jMenuItem2);
        this.mGenerateTsr = new JMenuItem("Generate diagnostic report...", 71);
        this.mGenerateTsr.setActionCommand(GENERATE_TSR);
        this.mGenerateTsr.addActionListener(this);
        ((JMenu)jMenuItem2).add(this.mGenerateTsr);
        if (!macMode) {
            ((JMenu)jMenuItem2).add(new JSeparator());
            jMenuItem = new JMenuItem("About NetExtender", 65);
            jMenuItem.setActionCommand(ABOUT);
            jMenuItem.addActionListener(this);
            ((JMenu)jMenuItem2).add(jMenuItem);
        }
        if (Boolean.valueOf(System.getProperty("com.sonicwall.nx.debug")).booleanValue()) {
            this.debugMenu = new JMenu("Debug");
            this.debugMenu.setMnemonic(68);
            this.menuBar.add(this.debugMenu);
            this.mShowDisconnectedPanel = new JMenuItem("Show disconnected panel", 68);
            this.mShowConnectingPanel = new JMenuItem("Show connecting panel", 67);
            this.mShowConnectedPanel = new JMenuItem("Show connected panel", 79);
            this.mShowDisconnectingPanel = new JMenuItem("Show disconnecting panel", 73);
            this.mDebug666 = new JMenuItem("DEBUG_666", 71);
            this.mShowDisconnectedPanel.setActionCommand(DEBUG_SHOW_DISCONNECTED_PANEL);
            this.mShowConnectingPanel.setActionCommand(DEBUG_SHOW_CONNECTING_PANEL);
            this.mShowConnectedPanel.setActionCommand(DEBUG_SHOW_CONNECTED_PANEL);
            this.mShowDisconnectingPanel.setActionCommand(DEBUG_SHOW_DISCONNECTING_PANEL);
            this.mDebug666.setActionCommand(DEBUG_666);
            this.mShowDisconnectedPanel.addActionListener(this);
            this.mShowConnectingPanel.addActionListener(this);
            this.mShowConnectedPanel.addActionListener(this);
            this.mShowDisconnectingPanel.addActionListener(this);
            this.mDebug666.addActionListener(this);
            this.debugMenu.add(this.mShowDisconnectedPanel);
            this.debugMenu.add(this.mShowConnectingPanel);
            this.debugMenu.add(this.mShowConnectedPanel);
            this.debugMenu.add(this.mShowDisconnectingPanel);
            this.debugMenu.add(this.mDebug666);
        }
        this.mainFrame.setJMenuBar(this.menuBar);
    }

    public void displayErrorMessage(String string) {
        this.rootPanel.displayErrorMessage(string);
    }

    public String promptForPassword(String string) {
        String string2 = PasswordDialog.getPassword(this.mainFrame, string, "NetExtender");
        if (string2 == null) {
            this.nxControl.disconnectNX();
        }
        return string2;
    }

    public String getRsaNewPin(String string) {
        String string2 = RsaNewPinDialog.getNewPin(this.mainFrame, string);
        if (string2 == null) {
            this.nxControl.disconnectNX();
        }
        return string2;
    }

    public String getRsaSysPin(String string) {
        String string2 = string.replaceAll(" *\\(y/n\\) *:?", "");
        if (JOptionPane.showConfirmDialog(this.mainFrame, string2, "NetExtender", 0, 3) == 0) {
            return "y";
        }
        return "n";
    }

    public String getRsaNextToken(String string) {
        String string2 = PasswordDialog.getPassword(this.mainFrame, string, "RSA Next Token");
        if (string2 == null) {
            this.nxControl.disconnectNX();
        }
        return string2;
    }

    public int getCertVerifyConfirm(String string, byte[] byArray) {
        int n = CertificateDialog.showCertDialog(this.mainFrame, "Certificate Viewer", string, byArray);
        return n;
    }

    public void showPasswordExpirationWarning(int n) {
        if (this.nxControl.mayUserChangePassword()) {
            String string = n < 0 ? "You must change your password before logging in.  Do you want to change it now?" : (n == 1 ? "Your password will expire in 1 day.\nDo you want to change it now?" : "Your password will expire in " + n + " days.\nDo you want to change it now?");
            if (JOptionPane.showConfirmDialog(this.mainFrame, string, "NetExtender", 0, 3) == 0) {
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                while (!bl) {
                    string2 = PasswordDialog.getPassword(this.mainFrame, "Enter your current password:", "NetExtender");
                    if (string2 == null) {
                        return;
                    }
                    string3 = PasswordDialog.getPassword(this.mainFrame, "Enter your desired new password:", "NetExtender");
                    if (string3 == null) {
                        string2 = null;
                        return;
                    }
                    string4 = PasswordDialog.getPassword(this.mainFrame, "Re-enter your desired new password:", "NetExtender");
                    if (string4 == null) {
                        string3 = null;
                        string2 = null;
                        return;
                    }
                    if (string3.equals(string4)) {
                        bl = true;
                        continue;
                    }
                    JOptionPane.showMessageDialog(this.mainFrame, "Passwords do not match - try again.", "NetExtender", 2);
                }
                String[] stringArray = new String[1];
                boolean bl2 = this.nxControl.sendPassChange(this.getDestinationIp(), this.getUsername(), this.getDomainValue(), string2, string3, stringArray);
                string4 = null;
                string3 = null;
                string2 = null;
                if (bl2) {
                    if (this.nxControl.isConnected()) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Your password was changed successfully.", "NetExtender", 1);
                    } else {
                        this.displayErrorMessage("Your password was changed successfully.  Please log in with your new password.");
                    }
                } else {
                    JOptionPane.showMessageDialog(this.mainFrame, "Password change failed!\n" + stringArray[0], "NetExtender", 2);
                }
            }
        } else {
            String string = n < 0 ? "You must change your password before logging in.  Please contact your administrator for assistance." : (n == 1 ? "Your password will expire in 1 day.\nYou should change it as soon as possible." : "Your password will expire in " + n + " days.\nYou should change it as soon as possible.");
            JOptionPane.showMessageDialog(this.mainFrame, string, "NetExtender", 2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        logger.fine("actionPerformed(" + string + ")");
        if (AUTH_FAILED.equals(string)) {
            this.rootPanel.showGui("GUI_DISCONNECTED");
            String string2 = this.nxControl.getAuthMessage();
            if (string2 != null) {
                this.displayErrorMessage(string2);
            } else {
                this.displayErrorMessage("Authentication Failed");
            }
        } else if (QUIT.equals(string)) {
            this.exit(0);
        } else if (ABOUT.equals(string)) {
            this.aboutDialog.setVisible(true);
        } else if (PREFERENCES.equals(string)) {
            this.preferencesDialog.setVisible(true);
        } else if (DISCONNECT.equals(string)) {
            this.nxControl.disconnectNX();
            this.rootPanel.showGui("GUI_DISCONNECTING");
        } else if (DISCONNECTING.equals(string)) {
            this.rootPanel.showGui("GUI_DISCONNECTING");
        } else if (DISCONNECTED.equals(string)) {
            this.rootPanel.showGui("GUI_DISCONNECTED");
            if (!this.mainFrame.isActive() || !this.mainFrame.isFocusOwner()) {
                this.mainFrame.requestFocus();
                this.mainFrame.toFront();
            }
        } else if (CONNECTING.equals(string)) {
            this.rootPanel.showGui("GUI_CONNECTING");
            if (this.nxThread != null) {
                if (this.nxThread.isAlive()) {
                    logger.warning("Previous NetExtender thread still alive");
                } else {
                    logger.fine("Previous NetExtender thread was not alive");
                    this.nxThread = null;
                }
            }
            if (this.nxThread == null) {
                boolean bl = true;
                if (this.nxControl.isInstallNeeded()) {
                    bl = false;
                    if (this.nxControl.promptForMaintenance()) {
                        bl = this.nxControl.fixPppdPermission();
                    }
                }
                if (bl) {
                    this.nxThread = new Thread(this.nxControl);
                    logger.fine("Starting the nx thread");
                    logger.fine("Launching connection thread");
                    this.nxThread.start();
                } else {
                    this.actionPerformed(new ActionEvent(this, 0, DISCONNECTED));
                }
            }
        } else if (RECONNECT.equals(string)) {
            this.rootPanel.showGui("GUI_CONNECTING");
            if (this.nxThread != null) {
                while (this.nxThread.isAlive()) {
                    logger.info("Previous NetExtender thread still alive. Waiting...");
                    try {
                        this.nxThread.join();
                        logger.info("Done waiting.");
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            this.nxThread = new Thread(this.nxControl);
            logger.fine("Starting the nx thread");
            logger.fine("Launching connection thread");
            this.nxThread.start();
        } else if (CONNECTED.equals(string)) {
            this.rootPanel.showGui("GUI_CONNECTED");
            logger.finer("uninstallAfterExit: " + this.nxControl.isUninstallAfterExit());
            logger.finer("exitAfterDisconnect: " + this.nxControl.isExitAfterDisconnect());
            logger.finer("noProfileCreate: " + this.nxControl.isNoProfileCreate());
            logger.finer("allowSavePassword: " + this.nxControl.isAllowSavePassword());
            logger.finer("allowSaveUser: " + this.nxControl.isAllowSaveUser());
            this.saveConnectionAsProfile();
        } else if (SHOW_LOG.equals(string)) {
            this.logDialog.setVisible(true);
        } else if (GENERATE_TSR.equals(string)) {
            this.generateTsr();
        } else if (DEBUG_SHOW_DISCONNECTED_PANEL.equals(string)) {
            this.rootPanel.showGui("GUI_DISCONNECTED");
        } else if (DEBUG_SHOW_CONNECTING_PANEL.equals(string)) {
            this.rootPanel.showGui("GUI_CONNECTING");
        } else if (DEBUG_SHOW_CONNECTED_PANEL.equals(string)) {
            this.rootPanel.showGui("GUI_CONNECTED");
        } else if (DEBUG_SHOW_DISCONNECTING_PANEL.equals(string)) {
            this.rootPanel.showGui("GUI_DISCONNECTING");
        } else if (DEBUG_666.equals(string)) {
            this.displayErrorMessage("<html>this is a really really really really really really really really really long message</html>");
        } else {
            logger.warning("Unknown Event: " + actionEvent);
        }
    }

    private void generateTsr() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save diagnostic report...");
        jFileChooser.setSelectedFile(new File("nxdiag.tgz"));
        if (jFileChooser.showSaveDialog(this.mainFrame) == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = null;
            try {
                string = file.getCanonicalPath();
                this.nxControl.generateTsr(string);
                JOptionPane.showMessageDialog(this.mainFrame, "A diagnostic report has been created at:\n" + string, "NetExtender Diagnostic Report", 1);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.mainFrame, "An error occurred while creating the diagnostic report.\n\nAttempted to create:\n" + string + "\n\nError:\n" + iOException.toString(), "NetExtender Diagnostic Report", 0);
            }
        }
    }

    private void saveConnectionAsProfile() {
        if (this.profileSavePreference == SAVE_NOTHING || this.nxControl.isNoProfileCreate()) {
            return;
        }
        Profile profile = new Profile();
        profile.setServer(this.destinationIp);
        if (this.nxControl.isAllowSaveUser()) {
            profile.setUsername(this.username);
        } else {
            profile.setUsername("");
        }
        if (this.profileSavePreference == SAVE_NAME_AND_PASS && this.nxControl.isAllowSavePassword()) {
            profile.setPassword(this.password);
        } else {
            profile.setPassword("");
        }
        profile.setDomain(this.domainValue);
        try {
            NetExtenderControl.getInstance().saveProfiles(profile);
        }
        catch (IOException iOException) {
            logger.severe("Error saving profiles");
        }
    }

    private static void createAndShowGUI() {
        NetExtender.getInstance().go();
    }

    public static ArrayList getClientIps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            string = NetExtender.getClientIpFromFile(CLIENT_IP_FILE);
            if (string != null) {
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            logger.warning("Could not read IPv4 client address from /etc/ppp/sslvpn.clientip:");
            logger.warning("  " + exception);
            logger.warning("  (If IPv4 client addresses are disabled, this warning is harmless)");
        }
        string = NetExtenderControl.getInstance().getClientIPv6Addr();
        if (string != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String getClientIpFromFile(String string) throws FileNotFoundException, IOException {
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        string2 = bufferedReader.readLine();
        bufferedReader.close();
        if (string2 != null) {
            return string2.trim();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-xapps")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            try {
                File file = new File("/tmp/netextender.pid");
                object2 = new FileOutputStream(file);
                object = ((FileOutputStream)object2).getChannel();
                FileLock fileLock = ((FileChannel)object).tryLock();
                Runtime.getRuntime().exec("chmod 666 /tmp/netextender.pid");
                if (null == fileLock) {
                    JOptionPane.showMessageDialog(null, "There is another NetExtender running now.", "NetExtender Message", 1);
                    System.exit(1);
                } else {
                    ((FileOutputStream)object2).write("NetExtender.jar\n".getBytes());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                System.err.println("cannot open the lock file\n");
                System.exit(1);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("cannot open the lock file\n");
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("cannot open the lock file\n");
                System.exit(1);
            }
        }
        if (stringArray.length > 0 && stringArray[0].equals("-V")) {
            try {
                NetExtender.readVersion();
            }
            catch (Exception exception) {
                version = "-1";
            }
            System.err.println(version);
            System.exit(1);
        }
        NetExtender.initLogging();
        NetExtender.handleCommandLineArgs(stringArray);
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable throwable) {
            object2 = System.getProperty("line.separator");
            object = "There was a problem creating the graphical interface." + (String)object2 + "Please make sure you have a compatible version of Java installed." + (String)object2 + "SonicWALL recommends Sun Java 1.4 or higher." + (String)object2 + "Alternatively, you can run the text-based version of NetExtender:" + (String)object2 + "  /usr/sbin/netExtender";
            logger.severe((String)object2 + (String)object);
            System.exit(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    logger.fine("Calling createAndShowGUI()");
                    NetExtender.createAndShowGUI();
                    logger.fine("Returned from createAndShowGUI()");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
    }

    private static void handleCommandLineArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            logger.fine("args[" + i + "] = " + stringArray[i]);
            if (stringArray[i].equals("-s") && stringArray.length > i + 1) {
                logger.fine("Param: sessionId = " + stringArray[i + 1]);
                NetExtender.getInstance().setSessionId(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-d") && stringArray.length > i + 1) {
                logger.fine("Param: destination = " + stringArray[i + 1]);
                NetExtender.getInstance().setDestinationIp(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-u") && stringArray.length > i + 1) {
                logger.fine("Param: username = " + stringArray[i + 1]);
                NetExtender.getInstance().setUsername(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-D") && stringArray.length > i + 1) {
                logger.fine("Param: domain = " + stringArray[i + 1]);
                NetExtender.getInstance().setDomainValue(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-V")) continue;
            System.err.println(version);
            System.exit(1);
        }
    }

    private static void initLogging() {
        String string = System.getenv("NXLOGPRIORITY");
        String string2 = "INFO";
        if (string != null) {
            if ("FATAL".equals(string = string.toUpperCase()) || "ERROR".equals(string)) {
                string2 = "SEVERE";
            } else if ("WARN".equals(string)) {
                string2 = "WARNING";
            } else if ("INFO".equals(string) || "NOTICE".equals(string)) {
                string2 = "CONFIG";
            } else if ("DEBUG".equals(string)) {
                string2 = "FINER";
            } else if ("TRACE".equals(string)) {
                string2 = "FINEST";
            }
        }
        Logger logger = Logger.getLogger("");
        Level level = Level.parse(string2.toUpperCase());
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            logger.removeHandler(handlerArray[i]);
        }
        NetExtenderLogFormatter netExtenderLogFormatter = new NetExtenderLogFormatter();
        ConsoleHandler consoleHandler = null;
        consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(level);
        consoleHandler.setFormatter(netExtenderLogFormatter);
        logger = Logger.getLogger("com.sonicwall");
        logger.setLevel(level);
        logger.addHandler(consoleHandler);
        NetExtender.logger = Logger.getLogger(NetExtender.class.getName());
        NetExtender.logger.info("Logging initialized.");
    }

    public static void initLogging2() {
        NetExtenderLogHandler netExtenderLogHandler = new NetExtenderLogHandler();
        Logger.getLogger("com.sonicwall").addHandler(netExtenderLogHandler);
    }

    public void exit(int n) {
        if (this.nxControl.isConnected()) {
            this.nxControl.disconnectNX();
        }
        if (this.nxControl.isUninstallAfterExitPref() && JOptionPane.showConfirmDialog(this.mainFrame, "Do you want to remove all the existing connection profiles?", "Uninstalling NetExtender", 0, 3) == 0) {
            Profile.deleteAllSavedProfiles();
        }
        this.nxControl.onNxExit();
        System.exit(n);
    }

    public String getDestinationIp() {
        return this.destinationIp;
    }

    public void setDestinationIp(String string) {
        this.destinationIp = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDomainValue() {
        return this.domainValue;
    }

    public void setDomainValue(String string) {
        this.domainValue = string;
    }

    public String getProfileSavePreference() {
        return this.profileSavePreference;
    }

    public void setProfileSavePreference(String string) {
        this.profileSavePreference = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public static boolean isMacMode() {
        return macMode;
    }

    public static String getVersion() {
        return version;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    static {
        macMode = false;
        nxIcon = null;
    }

    public static final class NetExtenderLogHandler
    extends Handler {
        private static final int NXLOG_TRACE = 0;
        private static final int NXLOG_DEBUG = 1;
        private static final int NXLOG_INFO = 2;
        private static final int NXLOG_NOTICE = 3;
        private static final int NXLOG_WARN = 4;
        private static final int NXLOG_ERROR = 5;
        private static final int NXLOG_FATAL = 6;

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            int n = 2;
            if (logRecord.getLevel() == Level.SEVERE) {
                n = 5;
            } else if (logRecord.getLevel() == Level.WARNING) {
                n = 4;
            } else if (logRecord.getLevel() == Level.INFO || logRecord.getLevel() == Level.CONFIG) {
                n = 2;
            } else if (logRecord.getLevel() == Level.FINE || logRecord.getLevel() == Level.FINER) {
                n = 1;
            } else if (logRecord.getLevel() == Level.FINEST) {
                n = 0;
            }
            NetExtenderControl.getInstance().nxlog(n, logRecord.getMessage());
        }
    }

    private static final class NetExtenderLogFormatter
    extends Formatter {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        String newline = System.getProperty("line.separator");

        private NetExtenderLogFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append(this.sdf.format(new Date(logRecord.getMillis()))).append(' ').append(logRecord.getLevel().getName()).append(' ').append(logRecord.getLoggerName()).append(' ').append(logRecord.getMessage()).append(this.newline);
            for (Throwable throwable = logRecord.getThrown(); throwable != null; throwable = throwable.getCause()) {
                if (!bl) {
                    stringBuffer.append("Caused by:").append(this.newline);
                }
                stringBuffer.append(throwable.toString()).append(this.newline);
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    stringBuffer.append("  ").append(stackTraceElementArray[i]).append(this.newline);
                }
                bl = false;
            }
            return stringBuffer.toString();
        }
    }
}

