/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall;

import com.sonicwall.NetExtenderControl;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Profile
implements Comparable {
    private String server;
    private String username;
    private String password;
    private String domain;
    private int trustcert;
    private static TreeMap profiles = new TreeMap();
    private static TreeMap profiles_server = new TreeMap();
    private static Profile defaultProfile = null;
    private static final Logger logger = Logger.getLogger(Profile.class.getName());

    public String toClearString() {
        return this.server + ':' + this.username + ":x:" + this.domain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.server);
        if (this.username != null && this.username.length() > 0 && this.domain != null && this.domain.length() > 0) {
            stringBuffer.append("(");
            stringBuffer.append(this.username);
            stringBuffer.append("@");
            stringBuffer.append(this.domain);
            stringBuffer.append(")");
        } else if (this.domain != null && this.domain.length() > 0) {
            stringBuffer.append("(");
            stringBuffer.append(this.domain);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static Profile getByServer(String string) {
        Profile profile = null;
        profile = (Profile)profiles.get(string);
        if (null == profile) {
            profile = (Profile)profiles_server.get(string);
        }
        return profile;
    }

    public static Profile getDefaultProfile() {
        return defaultProfile;
    }

    public static Iterator iterator() {
        if (profiles != null) {
            return profiles.values().iterator();
        }
        return null;
    }

    public static Profile[] loadSavedProfiles() throws IOException {
        Profile[] profileArray = NetExtenderControl.getInstance().loadSavedProfiles();
        if (profileArray != null && profileArray.length > 0) {
            defaultProfile = profileArray[0];
            profiles.clear();
            for (int i = 0; i < profileArray.length; ++i) {
                profiles.put(profileArray[i].toString(), profileArray[i]);
                profiles_server.put(profileArray[i].server, profileArray[i]);
            }
        }
        return profileArray;
    }

    public static void deleteAllSavedProfiles() {
        NetExtenderControl.getInstance().deleteAllSavedProfiles();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public int getTrustcert() {
        return this.trustcert;
    }

    public void setTrustcert(int n) {
        this.trustcert = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Profile)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        return this.server.compareTo(((Profile)object).server);
    }
}

