/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.Certificate;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.gui.CertificateDetail;
import it.sauronsoftware.base64.Base64;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CertificateImportPanel
extends JPanel
implements ActionListener {
    private static final String mClassName = "CertificateImportDialog";
    private DefaultMutableTreeNode mClientCertRootNode = null;
    private DefaultTreeModel mClientCertTreeModel = null;
    private DefaultMutableTreeNode mPubCertRootNode = null;
    private DefaultTreeModel mPubCertTreeModel = null;
    private JTree mClientCertTree = null;
    private JTree mPubCertTree = null;
    private JButton mImportButton = null;
    private JButton mDeleteButton = null;
    private JButton mCloseButton = null;
    private JButton mViewButton = null;
    private JButton mExportButton = null;
    private JButton mFactoryDefaultButton = null;
    private JFileChooser mCertFileChooser = null;
    private JComboBox mSelectedValueUpdateComponent = null;
    private ArrayList mClientCertRepositryList = new ArrayList();
    private ArrayList mPubCertRepositryList = new ArrayList();
    private JTextArea mHeaderLBL = null;
    private static final String NETEXTENDER_DIR = ".netExtenderCerts";
    private static final String PUB_CERT_DIR = "PUB_CERT";
    private static final String CLNT_CERT_DIR = "CLNT_CERT";
    private static final String CA_BUNDLE_FILE = "ca-bundle.crt";
    private static final String IMPORT_BTN_AC = "Import_Button_AC";
    private static final String DELETE_BTN_AC = "Delete_Button_AC";
    private static final String CLOSE_BTN_AC = "Close_Button_AC";
    private static final String FACTORY_BTN_AC = "Factory_Button_AC";
    private static final String VIEW_BTN_AC = "View_Button_AC";
    private static final String EXPORT_BTN_AC = "Export_Button_AC";
    public static final String CERTIMPDLG_BTN_IMPORT = "Import";
    public static final String COMMON_STR_DELETE = "Delete";
    public static final String COMMON_STR_FACTORY = "Factory Default";
    public static final String COMMON_STR_OK = "Ok";
    public static final String COMMON_STR_CANCEL = "Cancel";
    public static final String COMMON_STR_VIEW = "View";
    public static final String COMMON_STR_EXPORT = "Export";
    public static final String SELECT_IMPORTCERT = "Select Certificate to import";
    public static final String COMMON_STR_REPOSITRY = "Repository";
    public static final String CERTIMPDLG_LBL_ALWAYSACCEPT = "Trusted Root Certification Authorities.";
    public static final String CERTIMPDLG_LBL_REPOCERTS = "You have the following certificates in your trusted repository (Used for EPC only).";
    public static final String CERTIMPDLG_FC_SELECTCERT = "Select Certificate to import ...";
    public static final String CERTIMPDLG_LBL_CLIENT_CERTS = "Client Certificates";
    public static final String CERTIMPDLG_LBL_PUBLIC_CERTS = "Trusted CA Certificates";
    public static final String COMMON_CERT_CN = "Common Name";
    public static final String COMMON_CERT_EMAIL = "Email";
    public static final String COMMON_CERT_ORGNUNT = "OU";
    public static final String COMMON_CERT_ORGN = "Organization";
    public static final String COMMON_CERT_LOC = "Location";
    public static final String COMMON_CERT_ST = "State";
    public static final String COMMON_CERT_CO = "Country";
    public static final String COMMON_CERT_ISSUER = "Issued By";
    public static final String COMMON_CERT_ISSUEE = "Issued To";
    public static final String COMMON_CERT_VALIDITY = "Validity";
    public static final String COMMON_CERT_VALID_AFTER = "Valid After";
    public static final String COMMON_CERT_VALID_TILL = "Valid Until";
    public static final String COMMON_CERT_VALID = "Valid";
    public static final String COMMON_CERT_EXPIRE = "Expired";
    public static final String COMMON_CERT_NOTYET_VALID = "Not yet valid";
    public static final String COMMON_CERT_VERSION = "Version";
    public static final String COMMON_CERT_SERIAL = "Serial";
    public static final String COMMON_STATUS = "Status";
    public static final String COMMON_STR_SELECT = "Select";
    public static final String ERROR_INVALID_PKCS12_FILE = "This is invalid Certificate file";
    public static final String ERROR_CERT_ALREADY_EXISTSIN_STORE = "This certificate already exists in the store";
    public static final String ENTER_IMPORT_PASSWD = "Enter the import password";
    public static final byte PUBLIC_CERTIFICATE = 0;
    public static final byte CLIENT_CERTIFICATE = 1;
    private Certificate mSelectedClientCertificate = null;
    private static final Logger mLogger = Logger.getLogger(CertificateImportPanel.class.getName());
    private Certificate[] mClientCertsInRepo = null;
    private HashMap mNameCertMap = null;
    private byte mActiveTab = 1;
    private JDialog parent = null;

    public CertificateImportPanel(JDialog jDialog) {
        this.init();
        this.parent = jDialog;
    }

    private void init() {
        this.mNameCertMap = new HashMap();
        this.buildUI();
        this.getCertListFromRepositry();
        ArrayList arrayList = this.loadFromReposity();
        this.loadCertList(arrayList, (byte)1);
        NetExtenderControl.getInstance().verifyRootCAFile(false);
        arrayList = this.loadPublicRepository();
        this.loadCertList(arrayList, (byte)0);
    }

    private void setHeader(byte by) {
        if (by == 1) {
            this.mHeaderLBL.setText(CERTIMPDLG_LBL_REPOCERTS);
        } else {
            this.mHeaderLBL.setText(CERTIMPDLG_LBL_ALWAYSACCEPT);
        }
    }

    private void buildUI() {
        mLogger.finer("buildUI() ...");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(530, 380));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mHeaderLBL = new JTextArea(CERTIMPDLG_LBL_REPOCERTS);
        this.mHeaderLBL.setLineWrap(true);
        this.mHeaderLBL.setWrapStyleWord(true);
        this.mHeaderLBL.setEditable(false);
        this.mHeaderLBL.setOpaque(false);
        jPanel2.add((Component)this.mHeaderLBL, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.add(this.getTreePanel(0));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel4.add(this.getTreePanel(1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTabbedPane.addTab(CERTIMPDLG_LBL_CLIENT_CERTS, jPanel4);
        jTabbedPane.addTab(CERTIMPDLG_LBL_PUBLIC_CERTS, jPanel3);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == 1) {
                    CertificateImportPanel.this.mFactoryDefaultButton.setVisible(true);
                    CertificateImportPanel.this.mExportButton.setVisible(true);
                    CertificateImportPanel.this.setHeader((byte)0);
                    CertificateImportPanel.this.mActiveTab = (byte)0;
                } else {
                    CertificateImportPanel.this.mFactoryDefaultButton.setVisible(false);
                    CertificateImportPanel.this.mExportButton.setVisible(false);
                    CertificateImportPanel.this.setHeader((byte)1);
                    CertificateImportPanel.this.mActiveTab = (byte)1;
                }
            }
        });
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        this.mImportButton = new JButton(CERTIMPDLG_BTN_IMPORT);
        this.mImportButton.setActionCommand(IMPORT_BTN_AC);
        this.mImportButton.addActionListener(this);
        this.mExportButton = new JButton(COMMON_STR_EXPORT);
        this.mExportButton.setActionCommand(EXPORT_BTN_AC);
        this.mExportButton.addActionListener(this);
        this.mViewButton = new JButton(COMMON_STR_VIEW);
        this.mViewButton.setActionCommand(VIEW_BTN_AC);
        this.mViewButton.addActionListener(this);
        this.mDeleteButton = new JButton(COMMON_STR_DELETE);
        this.mDeleteButton.setActionCommand(DELETE_BTN_AC);
        this.mDeleteButton.addActionListener(this);
        this.mFactoryDefaultButton = new JButton(COMMON_STR_FACTORY);
        this.mFactoryDefaultButton.setActionCommand(FACTORY_BTN_AC);
        this.mFactoryDefaultButton.addActionListener(this);
        this.mCloseButton = new JButton(COMMON_STR_OK);
        this.mCloseButton.setActionCommand(CLOSE_BTN_AC);
        this.mCloseButton.addActionListener(this);
        jPanel6.add(this.mImportButton);
        jPanel6.add(this.mExportButton);
        jPanel6.add(this.mViewButton);
        jPanel6.add(this.mDeleteButton);
        jPanel6.add(this.mFactoryDefaultButton);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.mCloseButton);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        jPanel5.add((Component)jPanel6, "West");
        jPanel5.add((Component)jPanel7, "East");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)jPanel5, "South");
        this.add(jPanel);
        this.mCertFileChooser = new JFileChooser();
        this.mCertFileChooser.setMultiSelectionEnabled(false);
        this.mCertFileChooser.setFileSelectionMode(0);
        this.mCertFileChooser.setFileHidingEnabled(false);
        this.mCertFileChooser.setDialogTitle(SELECT_IMPORTCERT);
        this.mCloseButton.setVisible(false);
    }

    private JPanel getTreePanel(int n) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        if (n == 1) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.mClientCertRootNode = new DefaultMutableTreeNode(COMMON_STR_REPOSITRY);
            this.mClientCertTreeModel = new DefaultTreeModel(this.mClientCertRootNode);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.mClientCertTree = new JTree(this.mClientCertTreeModel);
            this.mClientCertTree.setRootVisible(true);
            this.mClientCertTree.getSelectionModel().setSelectionMode(1);
            jPanel2.add(this.mClientCertTree);
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jPanel.add(jScrollPane);
        } else if (n == 0) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.mPubCertRootNode = new DefaultMutableTreeNode(COMMON_STR_REPOSITRY);
            this.mPubCertTreeModel = new DefaultTreeModel(this.mPubCertRootNode);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.mPubCertTree = new JTree(this.mPubCertTreeModel);
            this.mPubCertTree.setRootVisible(true);
            jPanel3.add(this.mPubCertTree);
            JScrollPane jScrollPane = new JScrollPane(jPanel3);
            jPanel.add(jScrollPane);
        }
        return jPanel;
    }

    public void showDialog(boolean bl) {
        this.setVisible(bl);
    }

    public void setUpdateUIComponent(JComboBox jComboBox) {
        this.mSelectedValueUpdateComponent = jComboBox;
    }

    public void loadCertList(ArrayList arrayList, byte by) {
        mLogger.finer("loadCertList() ...");
        if (by == 1) {
            if (arrayList != null) {
                int n;
                if (this.mSelectedValueUpdateComponent != null) {
                    this.mSelectedValueUpdateComponent.removeAllItems();
                    for (n = 0; n < this.mClientCertsInRepo.length; ++n) {
                        this.mSelectedValueUpdateComponent.addItem(this.mClientCertsInRepo[n]);
                    }
                }
                this.mClientCertRepositryList = new ArrayList();
                this.deleteNodes(by);
                for (n = 0; n < arrayList.size(); ++n) {
                    if (arrayList.get(n) == null || ((Certificate)arrayList.get(n)).getX509Certificate() == null) continue;
                    mLogger.finer("Loading Client Cert [" + ((Certificate)arrayList.get(n)).getCertFilePath() + "]");
                    this.mClientCertRepositryList.add(((Certificate)arrayList.get(n)).getX509Certificate());
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getCertTree(((Certificate)arrayList.get(n)).getX509Certificate());
                    this.mNameCertMap.put(defaultMutableTreeNode, (Certificate)arrayList.get(n));
                    this.addToClientCertTree(defaultMutableTreeNode);
                }
                this.mClientCertTree.scrollPathToVisible(new TreePath(this.mClientCertRootNode.getFirstLeaf().getPath()));
            } else {
                this.mClientCertRepositryList.clear();
                this.deleteNodes(by);
            }
        } else if (by == 0) {
            if (arrayList != null) {
                this.deleteNodes(by);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if ((Certificate)arrayList.get(i) == null || ((Certificate)arrayList.get(i)).getX509Certificate() == null) continue;
                    mLogger.finer("Loading Public Cert [" + ((Certificate)arrayList.get(i)).getCertFilePath() + "]");
                    this.mPubCertRepositryList.add(((Certificate)arrayList.get(i)).getX509Certificate());
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getCertTree(((Certificate)arrayList.get(i)).getX509Certificate());
                    if (i <= 0) continue;
                    this.mNameCertMap.put(defaultMutableTreeNode, (Certificate)arrayList.get(i));
                    this.addToPubCertTree(defaultMutableTreeNode);
                }
                this.mPubCertTree.scrollPathToVisible(new TreePath(this.mPubCertRootNode.getFirstLeaf().getPath()));
            } else {
                this.deleteNodes(by);
            }
        }
    }

    private void deleteNodes(int n) {
        if (n == 1) {
            if (this.mClientCertRootNode != null) {
                Enumeration<TreeNode> enumeration = this.mClientCertRootNode.children();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        this.mClientCertRootNode.remove((DefaultMutableTreeNode)enumeration.nextElement());
                    }
                }
                this.mClientCertTreeModel.reload();
                this.mClientCertTree.repaint();
            }
        } else if (this.mPubCertRootNode != null) {
            Enumeration<TreeNode> enumeration = this.mPubCertRootNode.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    this.mPubCertRootNode.remove((DefaultMutableTreeNode)enumeration.nextElement());
                }
            }
            this.mPubCertTreeModel.reload();
            this.mPubCertTree.repaint();
        }
    }

    private void collapseTree() {
        for (int i = this.mClientCertTree.getRowCount() - 1; i >= 0; --i) {
            this.mClientCertTree.collapseRow(i);
        }
    }

    private static String removeLastComma(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        string = string.charAt(string.length() - 1) == ',' ? string.substring(0, string.length() - 1) : string.trim();
        String string2 = null;
        string2 = string.trim().equals("") ? null : string.trim();
        return string2;
    }

    public static String[] getCertificateFields(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Object object = new StringTokenizer(string, ",", false);
        if (object != null) {
            while (((StringTokenizer)object).hasMoreElements()) {
                StringTokenizer stringTokenizer;
                String string2 = (String)((StringTokenizer)object).nextElement();
                if (string2 == null || (stringTokenizer = new StringTokenizer(string2 = string2.trim(), "=", false)) == null || !stringTokenizer.hasMoreElements()) continue;
                String string3 = (String)stringTokenizer.nextElement();
                String string4 = null;
                if (string3 == null) continue;
                string3 = string3.trim();
                if (stringTokenizer.hasMoreElements()) {
                    string4 = (String)stringTokenizer.nextElement();
                }
                if (string4 == null || string4.trim().equals("")) continue;
                if (string3.equals("EMAILADDRESS")) {
                    stringBuffer2.append(string4 + ",");
                    continue;
                }
                if (string3.equals("CN")) {
                    stringBuffer.append(string4 + ",");
                    continue;
                }
                if (string3.equals(COMMON_CERT_ORGNUNT)) {
                    stringBuffer3.append(string4 + ",");
                    continue;
                }
                if (string3.equals("O")) {
                    stringBuffer4.append(string4 + ",");
                    continue;
                }
                if (string3.equals("L")) {
                    stringBuffer5.append(string4 + ",");
                    continue;
                }
                if (string3.equals("ST")) {
                    stringBuffer6.append(string4 + ",");
                    continue;
                }
                if (!string3.equals("C")) continue;
                stringBuffer7.append(string4 + ",");
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer2.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer3.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer4.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer5.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer6.toString()));
        ((ArrayList)object).add(CertificateImportPanel.removeLastComma(stringBuffer7.toString()));
        return ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getCertificateFromP12(String string, char[] cArray) {
        X509Certificate x509Certificate = null;
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(string), cArray);
            Object[] objectArray = null;
            Enumeration<String> enumeration = keyStore.aliases();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement().toString());
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                java.security.cert.Certificate[] certificateArray = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    java.security.cert.Certificate[] certificateArray2 = keyStore.getCertificateChain((String)objectArray[i]);
                    if (certificateArray != null && (certificateArray2 == null || certificateArray.length >= certificateArray2.length)) continue;
                    certificateArray = certificateArray2;
                }
                if (certificateArray != null) {
                    X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
                    for (int i = 0; i < certificateArray.length; ++i) {
                        x509CertificateArray[i] = certificateArray[i];
                    }
                    if (x509CertificateArray == null) {
                        mLogger.finer("Information unavailable. No certificate chain recorded in the keystore");
                        x509Certificate = null;
                    } else {
                        x509Certificate = x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0] instanceof X509Certificate ? x509CertificateArray[0] : null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return x509Certificate;
    }

    private void addToClientCertTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.collapseTree();
        this.mClientCertTreeModel.insertNodeInto(defaultMutableTreeNode, this.mClientCertRootNode, this.mClientCertRootNode.getChildCount());
    }

    private void addToPubCertTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.collapseTree();
        this.mPubCertTreeModel.insertNodeInto(defaultMutableTreeNode, this.mPubCertRootNode, this.mPubCertRootNode.getChildCount());
    }

    private void getPrincipalNodeWithValue(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string2 = "CERTDLG_NOT_PART_OF_CERT";
        String string3 = "<" + string2 + ">";
        String string4 = "<" + string2 + ">";
        String string5 = "<" + string2 + ">";
        String string6 = "<" + string2 + ">";
        String string7 = "<" + string2 + ">";
        String string8 = "<" + string2 + ">";
        String string9 = "<" + string2 + ">";
        string9 = "";
        string8 = "";
        string7 = "";
        string6 = "";
        string5 = "";
        string4 = "";
        string3 = "";
        String[] stringArray = CertificateImportPanel.getCertificateFields(string);
        try {
            if (stringArray != null) {
                if (stringArray[0] != null) {
                    string4 = stringArray[0];
                }
                if (stringArray[1] != null) {
                    string3 = stringArray[1];
                }
                if (stringArray[2] != null) {
                    string5 = stringArray[2];
                }
                if (stringArray[3] != null) {
                    string6 = stringArray[3];
                }
                if (stringArray[4] != null) {
                    string7 = stringArray[4];
                }
                if (stringArray[5] != null) {
                    string8 = stringArray[5];
                }
                if (stringArray[6] != null) {
                    string9 = stringArray[6];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Common Name: " + string3));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Email: " + string4));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("OU: " + string5));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Organization: " + string6));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Location: " + string7));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("State: " + string8));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Country: " + string9));
    }

    private DefaultMutableTreeNode getCertTree(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Issued By: ");
        String string = x509Certificate.getIssuerX500Principal().toString();
        this.getPrincipalNodeWithValue(string, defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Issued To: ");
        String string2 = x509Certificate.getSubjectX500Principal().toString();
        this.getPrincipalNodeWithValue(string2, defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Validity: ");
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Valid After: " + x509Certificate.getNotBefore()));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Valid Until: " + x509Certificate.getNotAfter()));
        String string3 = "";
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Status: " + string3));
        String string4 = defaultMutableTreeNode2.getFirstChild().toString();
        string4 = string4.substring(string4.indexOf(":") + 1);
        string4 = string4 == null || string4.trim().equals("") || string4.trim().length() == 0 ? string.replaceAll(", ", "/") : string4.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",", false);
        if (stringTokenizer != null) {
            if (stringTokenizer.hasMoreElements()) {
                string4 = (String)stringTokenizer.nextElement();
            }
            if (string4 == null || string4.trim().equals("")) {
                string4 = "Certificate";
            }
        }
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string4.trim());
        defaultMutableTreeNode4.add(defaultMutableTreeNode2);
        defaultMutableTreeNode4.add(defaultMutableTreeNode);
        defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Version: " + x509Certificate.getVersion()));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Serial: " + x509Certificate.getSerialNumber().toString(16)));
        return defaultMutableTreeNode4;
    }

    private boolean isCertificateInStore(X509Certificate x509Certificate) {
        if (this.mClientCertRepositryList.size() > 0) {
            return this.mClientCertRepositryList.contains(x509Certificate);
        }
        return false;
    }

    private boolean executeSystemCmd(String string) {
        boolean bl = true;
        mLogger.info("execute cmd [" + string + "]");
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                bl = false;
                mLogger.info("cmd output:" + string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    private boolean importCertificate(int n, String string) {
        boolean bl = false;
        boolean bl2 = true;
        if (n != 1) {
            Object object;
            Object object2;
            Object object3;
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            File file2 = new File(System.getProperty("user.home"));
            File file3 = new File(file2, ".netExtenderCerts/PUB_CERT/ca-bundle.crt");
            try {
                object3 = Runtime.getRuntime().exec("which openssl");
                ((Process)object3).waitFor();
                object2 = new BufferedReader(new InputStreamReader(((Process)object3).getInputStream()));
                object = ((BufferedReader)object2).readLine();
                if (((String)object).indexOf("no openssl in") > 0) {
                    mLogger.info((String)object);
                }
                bl2 = false;
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                if (!this.executeSystemCmd("cp " + string + " /tmp/snwl-cert.pem")) {
                    mLogger.info("copy imported file to tmp folder failed");
                    return false;
                }
                while (true) {
                    block24: {
                        if (!this.executeSystemCmd("openssl x509 -in /tmp/snwl-cert.pem -outform PEM -out /tmp/snwl-cert2.pem")) {
                            mLogger.info("Convert to PEM format failed");
                            break;
                        }
                        try {
                            object3 = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new StringBufferInputStream("/tmp/snwl-cert2.pem"));
                            if (object3 == null) break block24;
                            this.executeSystemCmd("cat /tmp/snwl-cert2.pem >> " + file3.getAbsolutePath());
                            bl = true;
                            this.mSelectedClientCertificate = new Certificate((X509Certificate)object3, "");
                            this.mPubCertRepositryList.add(object3);
                            object2 = this.getCertTree((X509Certificate)object3);
                            this.mNameCertMap.put(object2, this.mSelectedClientCertificate);
                            this.addToPubCertTree((DefaultMutableTreeNode)object2);
                        }
                        catch (CertificateException certificateException) {
                            mLogger.warning("Failed to import certificate:");
                            break;
                        }
                    }
                    try {
                        String string2;
                        this.executeSystemCmd("rm -f /tmp/snwl-cert1.pem");
                        object3 = new FileInputStream("/tmp/snwl-cert.pem");
                        object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                        object = new BufferedWriter(new FileWriter(new File("/tmp/snwl-cert1.pem")));
                        boolean bl3 = false;
                        int n2 = 0;
                        while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                            if (n2 == 2) {
                                n2 = 1;
                            }
                            if (string2.indexOf("-----END") != -1 && string2.indexOf("CERTIFICATE-----") != -1 && n2 != 1) {
                                n2 = 2;
                            }
                            if (n2 != 1) continue;
                            ((Writer)object).write(string2);
                            ((BufferedWriter)object).newLine();
                        }
                        ((InputStream)object3).close();
                        ((BufferedReader)object2).close();
                        ((BufferedWriter)object).close();
                        if (n2 != 1) break;
                        this.executeSystemCmd("rm -f /tmp/snwl-cert.pem");
                        this.executeSystemCmd("cp  /tmp/snwl-cert1.pem /tmp/snwl-cert.pem");
                    }
                    catch (IOException iOException) {
                        mLogger.warning("Failed to import certificate:" + iOException.toString());
                        break;
                    }
                }
                this.executeSystemCmd("rm -f /tmp/snwl-cert.pem /tmp/snwl-cert1.pem /tmp/snwl-cert.pem");
                this.executeSystemCmd("rm -f /tmp/snwl-cert.pem /tmp/snwl-cert1.pem /tmp/snwl-cert1.pem");
                this.executeSystemCmd("rm -f /tmp/snwl-cert.pem /tmp/snwl-cert1.pem /tmp/snwl-cert2.pem");
            } else {
                try {
                    String string3;
                    object3 = new FileInputStream(file);
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                    object = new BufferedWriter(new FileWriter(file3, true));
                    boolean bl4 = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = System.getProperty("line.separator");
                    while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                        if (string3.indexOf("BEGIN CERTIFICATE") != -1) {
                            bl4 = true;
                            bl = true;
                        }
                        if (bl4) {
                            ((Writer)object).write(string3);
                            ((BufferedWriter)object).newLine();
                            stringBuilder.append(string3);
                            stringBuilder.append(string4);
                        }
                        if (string3.indexOf("-----END CERTIFICATE-----") == -1) continue;
                        bl4 = false;
                        try {
                            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new StringBufferInputStream(stringBuilder.toString()));
                            this.mSelectedClientCertificate = new Certificate(x509Certificate, "");
                            this.mPubCertRepositryList.add(x509Certificate);
                            DefaultMutableTreeNode defaultMutableTreeNode = this.getCertTree(x509Certificate);
                            this.mNameCertMap.put(defaultMutableTreeNode, this.mSelectedClientCertificate);
                            this.addToPubCertTree(defaultMutableTreeNode);
                        }
                        catch (CertificateException certificateException) {
                            mLogger.warning("Unable to load certificate:");
                        }
                        stringBuilder.setLength(0);
                    }
                    ((InputStream)object3).close();
                    ((BufferedReader)object2).close();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    mLogger.warning("Failed to import certificate:" + exception.toString());
                }
            }
            this.savePublicRepository();
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(IMPORT_BTN_AC)) {
                mLogger.finer("User selected IMPORT button ...");
                this.mCertFileChooser.setSelectedFile(null);
                int n = this.mCertFileChooser.showDialog(this, COMMON_STR_SELECT);
                File file = this.mCertFileChooser.getSelectedFile();
                if (this.mActiveTab == 1) {
                    if (file != null && n == 0) {
                        JPasswordDialog jPasswordDialog = new JPasswordDialog(this.parent, true);
                        jPasswordDialog.setLocationRelativeTo(this);
                        jPasswordDialog.showDialog(true);
                        if (!jPasswordDialog.isDlgCanceled()) {
                            String string2 = jPasswordDialog.getResult();
                            char[] cArray = string2 != null ? string2.toCharArray() : null;
                            X509Certificate x509Certificate = CertificateImportPanel.getCertificateFromP12(file.getAbsolutePath(), cArray);
                            if (x509Certificate == null) {
                                JOptionPane.showMessageDialog(this, ERROR_INVALID_PKCS12_FILE);
                                return;
                            }
                            boolean bl = this.isCertificateInStore(x509Certificate);
                            if (bl) {
                                JOptionPane.showMessageDialog(this, ERROR_CERT_ALREADY_EXISTSIN_STORE, "Error", 0);
                            } else {
                                mLogger.finer("Selected Certificate [" + file.getAbsolutePath() + "]");
                                this.mSelectedClientCertificate = new Certificate(x509Certificate, file.getAbsolutePath());
                                this.mClientCertRepositryList.add(x509Certificate);
                                DefaultMutableTreeNode defaultMutableTreeNode = this.getCertTree(x509Certificate);
                                this.mNameCertMap.put(defaultMutableTreeNode, this.mSelectedClientCertificate);
                                this.addToClientCertTree(defaultMutableTreeNode);
                                this.saveToRepositry(string2);
                            }
                        }
                    }
                } else if (file != null && n == 0) {
                    this.importCertificate(0, file.getAbsolutePath());
                }
            } else if (string.equals(DELETE_BTN_AC)) {
                TreeNode[] treeNodeArray = null;
                if (this.mActiveTab == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mClientCertTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        treeNodeArray = this.mClientCertTreeModel.getPathToRoot(defaultMutableTreeNode);
                    }
                    if (treeNodeArray != null && treeNodeArray.length > 1) {
                        this.mSelectedClientCertificate = (Certificate)this.mNameCertMap.get(treeNodeArray[1]);
                        if (this.mSelectedClientCertificate != null) {
                            this.deleteCertificateFromRepositry(this.mActiveTab);
                            this.mNameCertMap.remove(treeNodeArray[1]);
                            this.mClientCertTreeModel.removeNodeFromParent((MutableTreeNode)treeNodeArray[1]);
                            this.mClientCertTreeModel.reload();
                            this.mClientCertTree.repaint();
                        }
                    }
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mPubCertTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        treeNodeArray = this.mPubCertTreeModel.getPathToRoot(defaultMutableTreeNode);
                    }
                    if (treeNodeArray != null && treeNodeArray.length > 1) {
                        this.mSelectedClientCertificate = (Certificate)this.mNameCertMap.get(treeNodeArray[1]);
                        if (this.mSelectedClientCertificate != null) {
                            this.deleteCertificateFromRepositry(this.mActiveTab);
                            this.mNameCertMap.remove(treeNodeArray[1]);
                            this.mPubCertTreeModel.removeNodeFromParent((MutableTreeNode)treeNodeArray[1]);
                            this.mPubCertTreeModel.reload();
                            this.mPubCertTree.repaint();
                        }
                    }
                }
            } else if (string.equals(FACTORY_BTN_AC)) {
                NetExtenderControl.getInstance().verifyRootCAFile(true);
                ArrayList arrayList = this.loadPublicRepository();
                this.loadCertList(arrayList, (byte)0);
            } else if (string.equals(CLOSE_BTN_AC)) {
                if (this.mSelectedValueUpdateComponent != null) {
                    this.mSelectedValueUpdateComponent.addItem(this.mSelectedClientCertificate);
                    mLogger.finer("Closing CertImportDlg");
                }
            } else if (string.equals(VIEW_BTN_AC)) {
                TreeNode[] treeNodeArray = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mPubCertTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    treeNodeArray = this.mPubCertTreeModel.getPathToRoot(defaultMutableTreeNode);
                }
                if (treeNodeArray != null && treeNodeArray.length > 1) {
                    this.mSelectedClientCertificate = (Certificate)this.mNameCertMap.get(treeNodeArray[1]);
                    if (this.mSelectedClientCertificate != null) {
                        CertificateDetail.ShowCertificateDetail(null, "Certificate", this.mSelectedClientCertificate.getX509Certificate());
                    }
                }
            } else if (string.equals(EXPORT_BTN_AC)) {
                int n = this.mCertFileChooser.showSaveDialog(this);
                if (n == 0) {
                    Object[] objectArray;
                    File file = this.mCertFileChooser.getSelectedFile();
                    mLogger.warning(file.getAbsolutePath());
                    if (file.exists()) {
                        objectArray = new Object[]{COMMON_STR_CANCEL, "Replace"};
                        if (1 != JOptionPane.showOptionDialog(this.parent, "A file named \"" + file.getName() + "\" already exists. Do you want to replace it?", "Warning", 0, 3, null, objectArray, objectArray[1])) {
                            return;
                        }
                    }
                    objectArray = null;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mPubCertTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        objectArray = this.mPubCertTreeModel.getPathToRoot(defaultMutableTreeNode);
                    }
                    if (objectArray != null && objectArray.length > 1) {
                        this.mSelectedClientCertificate = (Certificate)this.mNameCertMap.get(objectArray[1]);
                        if (this.mSelectedClientCertificate != null) {
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                                byte[] byArray = this.mSelectedClientCertificate.getX509Certificate().getEncoded();
                                outputStreamWriter.write("-----BEGIN CERTIFICATE-----\n");
                                char[] cArray = new String(Base64.encode(byArray)).toCharArray();
                                int n2 = cArray.length;
                                for (int i = 0; i < n2; i += 64) {
                                    if (i > 0) {
                                        ((Writer)outputStreamWriter).write(10);
                                    }
                                    ((Writer)outputStreamWriter).write(cArray, i, n2 - i > 64 ? 64 : n2 - i);
                                }
                                outputStreamWriter.write("\n-----END CERTIFICATE-----\n");
                                ((Writer)outputStreamWriter).flush();
                            }
                            catch (CertificateEncodingException certificateEncodingException) {
                                mLogger.warning("Certificate Encoding Exception");
                            }
                            catch (IOException iOException) {
                                mLogger.warning("IO Exception during export certificate");
                            }
                        }
                    }
                } else {
                    mLogger.info("Export certificate operation canceled");
                }
            }
        }
    }

    public void getCertListFromRepositry() {
        mLogger.finer("getCertListFromRepositry() ...");
    }

    private ArrayList loadPublicRepository() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, ".netExtenderCerts/PUB_CERT/ca-bundle.crt");
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file2.getAbsolutePath());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                if (0 != string.compareTo("-----END CERTIFICATE-----")) continue;
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new StringBufferInputStream(stringBuilder.toString()));
                    arrayList.add(new Certificate(x509Certificate, null));
                }
                catch (CertificateException certificateException) {
                    mLogger.warning("Unable to load certificate:");
                }
                stringBuilder.setLength(0);
            }
        }
        catch (CertificateException certificateException) {
            mLogger.warning("Unable to load certificate:");
        }
        catch (IOException iOException) {
            mLogger.warning("Unable to load certificate:" + iOException.toString());
        }
        return arrayList;
    }

    private void savePublicRepository() {
        try {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".netExtenderCerts/PUB_CERT");
            if (!file2.exists() && !file2.mkdirs()) {
                mLogger.warning("Unable to create directory:" + file2.getAbsolutePath());
                return;
            }
            long l = new Random().nextLong();
            mLogger.finer("random number:" + l);
            File file3 = new File(file, ".netExtenderCerts/PUB_CERT/ca-bundle.crt");
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            byte[] byArray = null;
            for (int i = 0; i < this.mPubCertRepositryList.size(); ++i) {
                if (this.mPubCertRepositryList.get(i) == null || (X509Certificate)this.mPubCertRepositryList.get(i) == null) continue;
                byArray = ((X509Certificate)this.mPubCertRepositryList.get(i)).getEncoded();
                outputStreamWriter.write("-----BEGIN CERTIFICATE-----\n");
                char[] cArray = new String(Base64.encode(byArray)).toCharArray();
                int n = cArray.length;
                for (int j = 0; j < n; j += 64) {
                    if (j > 0) {
                        ((Writer)outputStreamWriter).write(10);
                    }
                    ((Writer)outputStreamWriter).write(cArray, j, n - j > 64 ? 64 : n - j);
                }
                outputStreamWriter.write("\n-----END CERTIFICATE-----\n");
                ((Writer)outputStreamWriter).flush();
            }
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            mLogger.warning("Encoding certificate failed.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private ArrayList loadFromReposity() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, ".netExtenderCerts/CLNT_CERT");
        if (!file2.exists() || file2.listFiles() == null) {
            mLogger.finer("No certificate founds.");
            return null;
        }
        File[] fileArray = file2.listFiles();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(fileArray[i]));
                    arrayList.add(new Certificate(x509Certificate, fileArray[i].getAbsolutePath()));
                    continue;
                }
                catch (CertificateException certificateException) {
                    mLogger.warning("Unable to load certificate:" + fileArray[i].getAbsolutePath());
                    continue;
                }
                catch (IOException iOException) {
                    mLogger.warning("Unable to load certificate:" + iOException.toString());
                }
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return arrayList;
    }

    private void saveToRepositry(String string) {
        mLogger.finer("saveToRepositry() ...");
        try {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".netExtenderCerts/CLNT_CERT");
            if (!file2.exists() && !file2.mkdirs()) {
                mLogger.warning("Unable to create directory:" + file2.getAbsolutePath());
                return;
            }
            long l = new Random().nextLong();
            mLogger.finer("random number:" + l);
            File file3 = new File(file2, String.valueOf(l));
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            byte[] byArray = this.mSelectedClientCertificate.getX509Certificate().getEncoded();
            mLogger.finer("Import certificate to:" + file3.getAbsolutePath());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            outputStreamWriter.write("-----BEGIN CERTIFICATE-----\n");
            mLogger.finer("cert:" + new String(Base64.encode(byArray)));
            char[] cArray = new String(Base64.encode(byArray)).toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; i += 64) {
                if (i > 0) {
                    ((Writer)outputStreamWriter).write(10);
                }
                ((Writer)outputStreamWriter).write(cArray, i, n - i > 64 ? 64 : n - i);
            }
            outputStreamWriter.write("\n-----END CERTIFICATE-----\n");
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            mLogger.warning("Encoding certificate failed.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void deleteCertificateFromRepositry(int n) {
        if (n == 1) {
            mLogger.finer("deleteCertificateFromRepositry() ...");
            this.mClientCertRepositryList.remove(this.mSelectedClientCertificate.getX509Certificate());
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".netExtenderCerts/CLNT_CERT");
            if (!file2.exists() || file2.listFiles() == null) {
                mLogger.finer("Certificate not founds.");
                return;
            }
            File[] fileArray = file2.listFiles();
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(fileArray[i]));
                        if (x509Certificate != this.mSelectedClientCertificate.getX509Certificate()) continue;
                        fileArray[i].delete();
                        return;
                    }
                    catch (CertificateException certificateException) {
                        mLogger.warning("Unable to load certificate:" + fileArray[i].getAbsolutePath());
                        continue;
                    }
                    catch (IOException iOException) {
                        mLogger.warning("Unable to load certificate:" + iOException.toString());
                    }
                }
            }
            catch (CertificateException certificateException) {}
        } else if (n == 0) {
            mLogger.finer("deleteCertificateFromRepositry() ...");
            this.mPubCertRepositryList.remove(this.mSelectedClientCertificate.getX509Certificate());
            this.savePublicRepository();
        }
    }

    class JPasswordDialog
    extends JDialog {
        private JPasswordField mPassFieldTF;
        private JButton mOKBTN;
        private JButton mCancelBTN;
        private String mValue;
        private boolean mUserCancelDlg;

        public JPasswordDialog(JDialog jDialog, boolean bl) {
            super((Dialog)jDialog, bl);
            this.mPassFieldTF = null;
            this.mOKBTN = null;
            this.mCancelBTN = null;
            this.mValue = null;
            this.mUserCancelDlg = false;
            this.buildUI();
        }

        private void buildUI() {
            this.setResizable(false);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    JPasswordDialog.this.mUserCancelDlg = true;
                    JPasswordDialog.this.dispose();
                }
            });
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 5, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            JLabel jLabel = new JLabel("Enter the import password: ");
            this.mPassFieldTF = new JPasswordField();
            this.mPassFieldTF.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    switch (c) {
                        case '\u001b': {
                            JPasswordDialog.this.mCancelBTN.doClick();
                            break;
                        }
                        case '\n': {
                            JPasswordDialog.this.mOKBTN.doClick();
                        }
                    }
                }
            });
            jPanel2.add(jLabel);
            jPanel2.add(this.mPassFieldTF);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            this.mOKBTN = new JButton(CertificateImportPanel.COMMON_STR_OK);
            this.mOKBTN.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPasswordDialog.this.mValue = JPasswordDialog.this.mPassFieldTF.getText();
                    JPasswordDialog.this.dispose();
                }
            });
            this.mCancelBTN = new JButton(CertificateImportPanel.COMMON_STR_CANCEL);
            this.mCancelBTN.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPasswordDialog.this.mUserCancelDlg = true;
                    JPasswordDialog.this.dispose();
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.mCancelBTN);
            jPanel4.add(this.mOKBTN);
            jPanel3.add((Component)jPanel4, "East");
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jPanel3, "South");
            this.getContentPane().add(jPanel);
            this.pack();
        }

        public void showDialog(boolean bl) {
            this.setVisible(bl);
        }

        public String getResult() {
            return this.mValue;
        }

        public boolean isDlgCanceled() {
            return this.mUserCancelDlg;
        }
    }
}

