/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.DNSSettings;
import com.sonicwall.NetExtender;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.gui.BoldLabel;
import com.sonicwall.gui.NXPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ConnectedPanel
extends NXPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private NetExtenderControl nxControl;
    private Timer durationTimer;
    private JLabel statusLabel;
    private JLabel serverLabel;
    private JLabel clientIpLabel;
    private JLabel txBytesLabel;
    private JLabel rxBytesLabel;
    private JLabel durationLabel;
    private JLabel statusValueLabel;
    private JLabel serverValueLabel;
    private JLabel clientIpValueLabel;
    private JLabel txBytesValueLabel;
    private JLabel rxBytesValueLabel;
    private JLabel durationValueLabel;
    private JButton disconnectButton;
    private JTabbedPane tabs;
    private JPanel statusPanel;
    private JLabel tunnelAllPanel;
    private JScrollPane routesPanel;
    private JScrollPane dnsScroll;
    private JTable routesTable;
    private DNSPanel dnsPanel;
    private static final Logger logger = Logger.getLogger(ConnectedPanel.class.getName());
    long startTime;

    public ConnectedPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.nxControl = NetExtenderControl.getInstance();
        this.setLayout(new BoxLayout(this, 1));
        this.tabs = new JTabbedPane();
        this.statusPanel = new JPanel();
        this.statusPanel.setName("Status");
        if (NetExtender.isMacMode()) {
            this.statusPanel.setOpaque(false);
        }
        this.routesTable = new JTable(new DefaultTableModel(new String[]{"#", "Destination", "Netmask/Prefix"}, 0){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(false);
                }
                return component;
            }
        };
        if (NetExtender.isMacMode()) {
            this.routesTable.setOpaque(false);
        }
        this.routesTable.setShowGrid(false);
        this.routesTable.setRowSelectionAllowed(false);
        this.routesTable.setColumnSelectionAllowed(false);
        this.routesTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.routesPanel = new JScrollPane(this.routesTable);
        this.routesPanel.setName("Routes");
        this.routesPanel.setOpaque(false);
        this.routesPanel.getViewport().setOpaque(false);
        this.tunnelAllPanel = new JLabel("NetExtender is connected in TunnelAll Mode", 0);
        this.dnsPanel = new DNSPanel();
        this.dnsScroll = new JScrollPane(this.dnsPanel);
        this.dnsScroll.setName("DNS");
        this.dnsScroll.setOpaque(false);
        this.dnsScroll.getViewport().setOpaque(false);
        this.dnsScroll.setBorder(null);
        this.tabs.add(this.statusPanel);
        this.tabs.add(this.routesPanel);
        this.tabs.add(this.dnsScroll);
        this.tabs.setAlignmentX(1.0f);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusLabel = new BoldLabel("Status:", 4);
        this.serverLabel = new BoldLabel("Server:", 4);
        this.clientIpLabel = new BoldLabel("Client IP:", 4);
        this.txBytesLabel = new BoldLabel("Sent:", 4);
        this.rxBytesLabel = new BoldLabel("Received:", 4);
        this.durationLabel = new BoldLabel("Duration:", 4);
        this.statusValueLabel = new JLabel("Connected", 2);
        this.serverValueLabel = new JLabel("<server>", 2);
        this.clientIpValueLabel = new JLabel("<clientip>", 2);
        this.txBytesValueLabel = new JLabel("bytes sent", 2);
        this.rxBytesValueLabel = new JLabel("bytes received", 2);
        this.durationValueLabel = new JLabel("some time", 2);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.setActionCommand("disconnect");
        this.disconnectButton.addActionListener(NetExtender.getInstance());
        this.disconnectButton.setOpaque(false);
        this.disconnectButton.setAlignmentX(1.0f);
        this.add(this.tabs);
        this.add(this.disconnectButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.statusPanel.add((Component)this.serverLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.statusPanel.add((Component)this.clientIpLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.statusPanel.add((Component)this.txBytesLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.statusPanel.add((Component)this.rxBytesLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.statusPanel.add((Component)this.durationLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.statusPanel.add((Component)this.statusValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.statusPanel.add((Component)this.serverValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.statusPanel.add((Component)this.clientIpValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.statusPanel.add((Component)this.txBytesValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.statusPanel.add((Component)this.rxBytesValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.statusPanel.add((Component)this.durationValueLabel, gridBagConstraints);
    }

    public void activating() {
        ArrayList arrayList = NetExtender.getClientIps();
        StringBuffer stringBuffer = new StringBuffer("<html>");
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append(string);
            if (!object.hasNext()) continue;
            stringBuffer.append("<br>");
        }
        stringBuffer.append("</html>");
        object = stringBuffer.toString();
        this.serverValueLabel.setText(NetExtender.getInstance().getDestinationIp());
        this.clientIpValueLabel.setText((String)object);
        this.durationTimer = new Timer(1000, this);
        this.durationTimer.setInitialDelay(0);
        this.durationTimer.setDelay(1000);
        this.durationTimer.start();
        this.startTime = System.currentTimeMillis();
        logger.finest("activating: calling updateRoutes()");
        this.updateRoutes();
        logger.finest("activating: returned from updateRoutes()");
        logger.finest("activating: calling dnsPanel.updateDns()");
        this.dnsPanel.updateDns();
        logger.finest("activating: returned from dnsPanel.updateDns()");
        logger.finest("activating: returning");
    }

    public void activated() {
        int n = this.nxControl.getPwdExpDays();
        if (n != Integer.MAX_VALUE) {
            NetExtender.getInstance().showPasswordExpirationWarning(n);
        }
    }

    public void deactivating() {
        logger.finest("deactivating: Stopping timer");
        if (this.durationTimer != null) {
            this.durationTimer.stop();
        }
    }

    public JButton getDefaultButton() {
        return this.disconnectButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.durationTimer)) {
            logger.finest("tick...");
            long l = System.currentTimeMillis() - this.startTime;
            int n = (int)l / 3600000;
            int n2 = (int)l / 60000 - n * 60;
            int n3 = (int)l / 1000 - n * 60 * 60 - n2 * 60;
            String string = Integer.toString(n).length() == 1 ? Integer.toString(0).concat(Integer.toString(n)) : Integer.toString(n);
            String string2 = Integer.toString(n2).length() == 1 ? Integer.toString(0).concat(Integer.toString(n2)) : Integer.toString(n2);
            String string3 = Integer.toString(n3).length() == 1 ? Integer.toString(0).concat(Integer.toString(n3)) : Integer.toString(n3);
            this.durationValueLabel.setText(string + ":" + string2 + ":" + string3);
            this.txBytesValueLabel.setText(this.nxControl.getTxBytes() + " Bytes");
            this.rxBytesValueLabel.setText(this.nxControl.getRxBytes() + " Bytes");
            if (this.nxControl.getNetExtenderState() == 3) {
                NetExtender.getInstance().actionPerformed(new ActionEvent(this, 1001, "disconnecting"));
            }
        }
    }

    public void updateRoutes() {
        String string = this.nxControl.getRoutes();
        logger.finer("updateRoutes: routesStr = <" + string + ">");
        if (string != null) {
            int n = this.tabs.getSelectedIndex();
            this.tabs.remove(this.routesPanel);
            this.tabs.remove(this.tunnelAllPanel);
            if (string.indexOf("/default/") > -1 || string.indexOf("/0.0.0.0/") > -1) {
                logger.fine("updateRoutes: Tunnel all mode");
                this.tabs.insertTab("Routes", null, this.tunnelAllPanel, null, 1);
            } else {
                logger.fine("updateRoutes: Split tunnel mode");
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.routesTable.getModel();
                while (defaultTableModel.getRowCount() > 0) {
                    defaultTableModel.removeRow(0);
                }
                String[] stringArray = string.split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    logger.finest("updateRoutes: i = " + i);
                    defaultTableModel.addRow(stringArray[i].split("/"));
                    logger.fine("updateRoutes: model.getRowCount() = " + defaultTableModel.getRowCount());
                }
                logger.finest("updateRoutes: exited for loop");
                this.tabs.insertTab("Routes", null, this.routesPanel, null, 1);
            }
            this.tabs.setSelectedIndex(n);
        }
        logger.finest("updateRoutes: returning");
    }

    private final class DNSPanel
    extends JPanel {
        private JLabel servers;
        private JLabel suffix;

        public DNSPanel() {
            this.setLayout(new GridBagLayout());
            if (NetExtender.isMacMode()) {
                this.setOpaque(false);
            }
            this.servers = new JLabel();
            this.suffix = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            this.add((Component)new BoldLabel("DNS Servers:"), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)new BoldLabel("DNS Suffix:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            this.add((Component)this.servers, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.suffix, gridBagConstraints);
        }

        public void updateDns() {
            DNSSettings dNSSettings = ConnectedPanel.this.nxControl.getDnsSettings();
            if (dNSSettings.server1 != null && dNSSettings.server2 != null) {
                this.servers.setText("<html>" + dNSSettings.server1 + "<br>" + dNSSettings.server2 + "</html>");
            } else if (dNSSettings.server1 != null) {
                this.servers.setText(dNSSettings.server1);
            } else if (dNSSettings.server2 != null) {
                this.servers.setText(dNSSettings.server2);
            } else {
                this.servers.setText("None Specified");
            }
            if (dNSSettings.hasSuffixes()) {
                StringBuilder stringBuilder = new StringBuilder("<html>");
                for (int i = 0; i < dNSSettings.suffixes.length && dNSSettings.suffixes[i] != null; ++i) {
                    if (i > 0) {
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append(dNSSettings.suffixes[i]);
                }
                stringBuilder.append("</html>");
                this.suffix.setText(stringBuilder.toString());
            } else {
                this.suffix.setText("None Specified");
            }
        }
    }
}

