/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.NetExtender;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.gui.NXPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

public class ConnectingPanel
extends NXPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Timer connectionTimer;
    private JLabel connectingLabel;
    private JProgressBar connectingProgress;
    private String destination;
    private static final Logger logger = Logger.getLogger(ConnectingPanel.class.getName());

    public ConnectingPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(0, 80)));
        Box box = new Box(1);
        box.setBackground(new Color(0xF8F8F8));
        box.setAlignmentX(0.5f);
        box.setBorder(new CompoundBorder(new LineBorder(new Color(0xDADADA)), new MatteBorder(30, 30, 30, 30, box.getBackground())));
        box.setOpaque(true);
        this.connectingLabel = new JLabel("Connecting to SSL VPN...", 10);
        this.connectingLabel.setAlignmentX(0.0f);
        this.connectingLabel.setBackground(box.getBackground());
        this.connectingProgress = new JProgressBar();
        this.connectingProgress.setIndeterminate(true);
        this.connectingProgress.setOpaque(false);
        this.connectingProgress.setMinimumSize(new Dimension(360, 20));
        this.connectingProgress.setMaximumSize(new Dimension(360, 20));
        this.connectingProgress.setPreferredSize(new Dimension(360, 20));
        this.connectingProgress.setAlignmentX(0.0f);
        box.add(this.connectingLabel);
        box.add(this.connectingProgress);
        this.add(box);
    }

    public void activating() {
        this.connectingLabel.setText("Connecting to " + NetExtender.getInstance().getDestinationIp() + "...");
        if (this.connectionTimer == null) {
            this.connectionTimer = new Timer(1000, this);
            this.connectionTimer.setInitialDelay(0);
            this.connectionTimer.setDelay(1000);
        }
        this.connectionTimer.start();
    }

    public void activated() {
    }

    public void deactivated() {
        this.connectionTimer.stop();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource().equals(this.connectionTimer) && (bl = NetExtenderControl.getInstance().isConnected())) {
            this.connectionTimer.stop();
            logger.fine("Connected ...");
            NetExtender.getInstance().actionPerformed(new ActionEvent(this, 0, "connected"));
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String string) {
        this.destination = string;
        this.connectingLabel.setText("Connecting to " + string);
    }
}

