/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.NetExtender;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.Profile;
import com.sonicwall.gui.AutoSelector;
import com.sonicwall.gui.ErrorPanel;
import com.sonicwall.gui.NXPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DisconnectedPanel
extends NXPanel
implements FocusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String CONNECT = "connect";
    public static final String DST_FIELD_CHANGED = "dstFieldChanged";
    private JLabel dstLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private JLabel domainLabel;
    private JLabel profileSavePreferenceLabel;
    private JComboBox dstField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField domainField;
    private JComboBox profileSavePreferenceField;
    private JButton connectButton;
    private ErrorPanel errorText;
    private static final Logger logger = Logger.getLogger(DisconnectedPanel.class.getName());

    public DisconnectedPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new LoginPanel());
        this.profileSavePreferenceLabel = new JLabel("Save profile:");
        this.profileSavePreferenceField = new JComboBox<String>(new String[]{"Save name and password (if allowed)", "Save username only (if allowed)", "Do not save profile"});
        this.profileSavePreferenceField.setEditable(false);
        this.profileSavePreferenceField.setOpaque(false);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.add(this.profileSavePreferenceField);
        if (NetExtender.isMacMode()) {
            this.dstField.addFocusListener(AutoSelector.getInstance());
            this.usernameField.addFocusListener(AutoSelector.getInstance());
            this.passwordField.addFocusListener(AutoSelector.getInstance());
            this.domainField.addFocusListener(AutoSelector.getInstance());
        }
        this.dstField.addActionListener(this);
        this.dstField.setActionCommand(DST_FIELD_CHANGED);
        this.validate();
        this.repaint();
    }

    public void loadProfiles() {
        try {
            Profile[] profileArray = Profile.loadSavedProfiles();
            if (profileArray == null) {
                logger.config("Could not load saved profiles");
                return;
            }
            logger.finer("Loaded " + profileArray.length + " profiles.");
            this.dstField.removeAllItems();
            for (int i = 0; i < profileArray.length; ++i) {
                logger.finer("Profile: " + profileArray[i].toClearString());
                if (!"".equals(profileArray[i].getPassword())) {
                    logger.finer("  Password: <saved>");
                } else {
                    logger.finer("  Password: <null>");
                }
                this.dstField.addItem(profileArray[i].toString());
            }
            Profile profile = Profile.getDefaultProfile();
            if (profile != null) {
                this.dstField.setSelectedItem(profile.toString());
            }
        }
        catch (IOException iOException) {
            logger.config("Could not load saved profiles");
        }
    }

    public void setErrorText(String string) {
        this.errorText.setText(string);
        this.errorText.setVisible(string != null && string.length() > 0);
        if (string != null && string.indexOf("PIN accepted") >= 0) {
            this.errorText.setStatus(1);
        } else {
            this.errorText.setStatus(0);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        logger.fine(focusEvent.getComponent().getName() + " lost focus");
        if (focusEvent.getComponent().getName().equals("dstField")) {
            logger.fine("Detected entry for sslvpn appliance at :" + this.dstField.getSelectedItem());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CONNECT.equals(string)) {
            String string2;
            int n;
            logger.fine(string + " command received");
            String string3 = this.dstField.getSelectedItem() instanceof Profile ? ((Profile)this.dstField.getSelectedItem()).getServer() : ((n = (string2 = (String)this.dstField.getSelectedItem()).indexOf(40)) < 0 ? string2 : string2.substring(0, n));
            string2 = this.usernameField.getText();
            String string4 = new String(this.passwordField.getPassword());
            String string5 = this.domainField.getText();
            if (string3.trim().length() == 0) {
                this.setErrorText("Please provide the SSL VPN address.");
                return;
            }
            if (string2.trim().length() == 0) {
                this.setErrorText("Please enter a username.");
                return;
            }
            if (string4.trim().length() == 0) {
                this.setErrorText("Please enter the password.");
                return;
            }
            if (string5.trim().length() == 0) {
                this.setErrorText("Please enter a domain.");
                return;
            }
            NetExtender netExtender = NetExtender.getInstance();
            netExtender.setUsername(string2);
            netExtender.setPassword(string4);
            netExtender.setDomainValue(string5);
            netExtender.setDestinationIp(string3);
            netExtender.setProfileSavePreference((String)this.profileSavePreferenceField.getSelectedItem());
            NetExtenderControl netExtenderControl = NetExtenderControl.getInstance();
            netExtenderControl.setUsername(string2);
            netExtenderControl.setPassword(string4);
            netExtenderControl.setDomain(string5);
            netExtenderControl.setDestination(string3);
            NetExtender.getInstance().actionPerformed(new ActionEvent(this, 1001, "connecting"));
        } else if (DST_FIELD_CHANGED.equals(string)) {
            if (this.dstField.getSelectedItem() instanceof Profile) {
                Profile profile = (Profile)this.dstField.getSelectedItem();
                this.usernameField.setText(profile.getUsername());
                this.passwordField.setText(profile.getPassword());
                this.domainField.setText(profile.getDomain());
            } else if (this.dstField.getSelectedItem() instanceof String) {
                Profile profile = Profile.getByServer((String)this.dstField.getSelectedItem());
                if (profile != null) {
                    this.usernameField.setText(profile.getUsername());
                    this.passwordField.setText(profile.getPassword());
                    this.domainField.setText(profile.getDomain());
                    this.dstField.setSelectedItem(profile.getServer());
                } else {
                    this.usernameField.setText("");
                    this.passwordField.setText("");
                    this.domainField.setText("");
                }
            }
        }
    }

    public JButton getDefaultButton() {
        return this.connectButton;
    }

    public void activating() {
        super.activating();
        this.loadProfiles();
        String string = NetExtender.getInstance().getProfileSavePreference();
        if (string == "Save username only (if allowed)") {
            this.passwordField.setText("");
        } else if (string == "Do not save profile") {
            this.usernameField.setText("");
            this.passwordField.setText("");
        }
    }

    public void activated() {
        super.activated();
        if (NetExtenderControl.getInstance().isExitAfterDisconnect()) {
            NetExtender.getInstance().exit(0);
        }
    }

    private final class LoginPanel
    extends JPanel {
        public LoginPanel() {
            NetExtender netExtender = NetExtender.getInstance();
            this.setLayout(new GridBagLayout());
            this.setBorder(new LineBorder(new Color(170, 170, 170)));
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            DisconnectedPanel.this.dstField = new JComboBox();
            DisconnectedPanel.this.dstField.setEditable(true);
            DisconnectedPanel.this.dstField.setOpaque(false);
            DisconnectedPanel.this.dstLabel = new JLabel("Server:", 2);
            DisconnectedPanel.this.dstLabel.setLabelFor(DisconnectedPanel.this.dstField);
            DisconnectedPanel.this.dstField.setName("dstField");
            if (netExtender.getDestinationIp() != null) {
                DisconnectedPanel.this.dstField.setSelectedItem(netExtender.getDestinationIp());
            }
            DisconnectedPanel.this.usernameField = new JTextField();
            DisconnectedPanel.this.usernameLabel = new JLabel("Username:", 2);
            DisconnectedPanel.this.usernameLabel.setLabelFor(DisconnectedPanel.this.usernameField);
            DisconnectedPanel.this.passwordField = new JPasswordField();
            DisconnectedPanel.this.passwordLabel = new JLabel("Password:", 2);
            DisconnectedPanel.this.passwordLabel.setLabelFor(DisconnectedPanel.this.passwordField);
            DisconnectedPanel.this.domainField = new JTextField();
            if (netExtender.getDomainValue() != null) {
                DisconnectedPanel.this.domainField.setText(netExtender.getDomainValue());
            }
            DisconnectedPanel.this.domainLabel = new JLabel("Domain:", 2);
            DisconnectedPanel.this.domainLabel.setLabelFor(DisconnectedPanel.this.domainField);
            DisconnectedPanel.this.connectButton = new JButton("Connect");
            DisconnectedPanel.this.connectButton.setActionCommand(DisconnectedPanel.CONNECT);
            DisconnectedPanel.this.connectButton.addActionListener(DisconnectedPanel.this);
            DisconnectedPanel.this.connectButton.setOpaque(false);
            DisconnectedPanel.this.errorText = new ErrorPanel();
            DisconnectedPanel.this.errorText.setVisible(false);
            this.addAndlayoutComponents();
        }

        private void addAndlayoutComponents() {
            Box box = new Box(1);
            Box box2 = new Box(1);
            box2.setAlignmentX(0.5f);
            box2.setMaximumSize(new Dimension(298, 153));
            DisconnectedPanel.this.errorText.setAlignmentX(0.5f);
            box.add(DisconnectedPanel.this.errorText);
            box.add(Box.createRigidArea(new Dimension(0, 6)));
            Box box3 = new Box(0);
            box3.add(Box.createGlue());
            box3.add(DisconnectedPanel.this.dstLabel);
            DisconnectedPanel.this.dstField.setMaximumSize(new Dimension(215, 28));
            DisconnectedPanel.this.dstField.setMinimumSize(new Dimension(215, 28));
            DisconnectedPanel.this.dstField.setPreferredSize(new Dimension(215, 28));
            box3.add(DisconnectedPanel.this.dstField);
            box2.add(box3);
            box3 = new Box(0);
            box3.setAlignmentX(0.5f);
            box3.add(Box.createGlue());
            box3.add(DisconnectedPanel.this.usernameLabel);
            DisconnectedPanel.this.usernameField.setMaximumSize(new Dimension(215, 28));
            DisconnectedPanel.this.usernameField.setMinimumSize(new Dimension(215, 28));
            DisconnectedPanel.this.usernameField.setPreferredSize(new Dimension(215, 28));
            box3.add(DisconnectedPanel.this.usernameField);
            box2.add(box3);
            box3 = new Box(0);
            box3.setAlignmentX(0.5f);
            box3.add(Box.createGlue());
            box3.add(DisconnectedPanel.this.passwordLabel);
            DisconnectedPanel.this.passwordField.setMaximumSize(new Dimension(215, 28));
            DisconnectedPanel.this.passwordField.setMinimumSize(new Dimension(215, 28));
            DisconnectedPanel.this.passwordField.setPreferredSize(new Dimension(215, 28));
            box3.add(DisconnectedPanel.this.passwordField);
            box2.add(box3);
            box3 = new Box(0);
            box3.setAlignmentX(0.5f);
            box3.add(Box.createGlue());
            box3.add(DisconnectedPanel.this.domainLabel);
            DisconnectedPanel.this.domainField.setMaximumSize(new Dimension(215, 28));
            DisconnectedPanel.this.domainField.setMinimumSize(new Dimension(215, 28));
            DisconnectedPanel.this.domainField.setPreferredSize(new Dimension(215, 28));
            box3.add(DisconnectedPanel.this.domainField);
            box2.add(box3);
            box3 = new Box(0);
            box3.add(Box.createGlue());
            box3.add(DisconnectedPanel.this.connectButton);
            box2.add(box3);
            box.add(box2);
            this.add(box);
        }
    }
}

