/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.NetExtender;
import com.sonicwall.gui.NetExtenderRootPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ErrorPanel
extends JPanel {
    public static final int ERROR = 0;
    public static final int SUCCESS = 1;
    private static final int ROUNDED_CORNER_RADIUS = 20;
    private static final Color BORDER_COLOR_ERROR = new Color(9535359);
    private static final Color BACKGROUND_COLOR_ERROR = new Color(15918308);
    private static final Color TEXT_COLOR_ERROR = new Color(0x990000);
    private static final Color BORDER_COLOR_SUCCESS = new Color(8556927);
    private static final Color BACKGROUND_COLOR_SUCCESS = new Color(15135460);
    private static final Color TEXT_COLOR_SUCCESS = new Color(39168);
    private static final Image ICON_ERROR = NetExtender.loadImage("img/alert_error.gif");
    private static final Image ICON_SUCCESS = NetExtender.loadImage("img/alert_success.gif");
    private int status = 0;
    private JTextArea messageDisplay;
    private Color borderColor;
    private Color backgroundColor;
    private Color textColor;
    private Image icon;
    private boolean visible;

    public ErrorPanel() {
        this(0);
    }

    public ErrorPanel(int n) {
        this.setLayout(new BoxLayout(this, 0));
        this.messageDisplay = new JTextArea("\n\n");
        this.messageDisplay.setFont(NetExtenderRootPanel.FONT);
        this.messageDisplay.setForeground(Color.RED);
        this.messageDisplay.setEditable(false);
        this.messageDisplay.setWrapStyleWord(true);
        this.messageDisplay.setLineWrap(true);
        this.messageDisplay.setMaximumSize(new Dimension(330, 38));
        this.messageDisplay.setMinimumSize(new Dimension(330, 38));
        this.messageDisplay.setPreferredSize(new Dimension(330, 38));
        this.setMaximumSize(new Dimension(380, 52));
        this.setMinimumSize(new Dimension(380, 52));
        this.setPreferredSize(new Dimension(380, 52));
        this.add(Box.createRigidArea(new Dimension(40, 0)));
        this.add(this.messageDisplay);
        this.setStatus(0);
    }

    public void setStatus(int n) {
        switch (n) {
            case 0: {
                this.borderColor = BORDER_COLOR_ERROR;
                this.backgroundColor = BACKGROUND_COLOR_ERROR;
                this.textColor = TEXT_COLOR_ERROR;
                this.icon = ICON_ERROR;
                break;
            }
            case 1: {
                this.borderColor = BORDER_COLOR_SUCCESS;
                this.backgroundColor = BACKGROUND_COLOR_SUCCESS;
                this.textColor = TEXT_COLOR_SUCCESS;
                this.icon = ICON_SUCCESS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Status must be ErrorPanel.ERROR or ErrorPanel.SUCCESS");
            }
        }
        this.messageDisplay.setBackground(this.backgroundColor);
        this.messageDisplay.setForeground(this.textColor);
    }

    public void setText(String string) {
        this.messageDisplay.setText(string);
    }

    public boolean isVisible() {
        return true;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.messageDisplay.setVisible(bl);
        this.setOpaque(bl);
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.visible) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.drawImage(this.icon, 0, 10, this);
            graphics.setColor(this.borderColor);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

