/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.gui.BannerPanel;
import com.sonicwall.gui.ConnectedPanel;
import com.sonicwall.gui.ConnectingPanel;
import com.sonicwall.gui.DisconnectedPanel;
import com.sonicwall.gui.DisconnectingPanel;
import com.sonicwall.gui.NXPanel;
import com.sonicwall.gui.StatusBarPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class NetExtenderRootPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String GUI_DISCONNECTED = "GUI_DISCONNECTED";
    public static final String GUI_CONNECTED = "GUI_CONNECTED";
    public static final String GUI_CONNECTING = "GUI_CONNECTING";
    public static final String GUI_DISCONNECTING = "GUI_DISCONNECTING";
    public static final int PAD = 5;
    public static final Font FONT = new Font("Arial", 0, 12);
    private JFrame frame;
    private JPanel contentPanel;
    private DisconnectedPanel disconnectedPanel;
    private ConnectingPanel connectingPanel;
    private ConnectedPanel connectedPanel;
    private DisconnectingPanel disconnectingPanel;
    private HashMap panels;
    private NXPanel currentPanel;
    private static final Logger logger = Logger.getLogger(NetExtenderRootPanel.class.getName());

    public NetExtenderRootPanel(JFrame jFrame) {
        this.frame = jFrame;
        this.setLayout(new BorderLayout());
        Font font = this.getFont();
        logger.finest("currentFont = " + font);
        this.add((Component)new BannerPanel(), "North");
        this.add((Component)new StatusBarPanel(), "South");
        this.contentPanel = new JPanel(new CardLayout());
        this.panels = new HashMap();
        this.disconnectedPanel = new DisconnectedPanel();
        this.connectingPanel = new ConnectingPanel();
        this.connectedPanel = new ConnectedPanel();
        this.disconnectingPanel = new DisconnectingPanel();
        this.addPanel(this.disconnectedPanel, GUI_DISCONNECTED);
        this.addPanel(this.connectingPanel, GUI_CONNECTING);
        this.addPanel(this.connectedPanel, GUI_CONNECTED);
        this.addPanel(this.disconnectingPanel, GUI_DISCONNECTING);
        this.contentPanel.setBorder(new MatteBorder(30, 98, 30, 98, Color.WHITE));
        this.add((Component)this.contentPanel, "Center");
    }

    private void addPanel(NXPanel nXPanel, String string) {
        this.contentPanel.add((Component)nXPanel, string);
        this.panels.put(string, nXPanel);
        if (this.currentPanel == null) {
            this.currentPanel = nXPanel;
        }
    }

    public void showGui(String string) {
        logger.fine("showGui(" + string + ")");
        CardLayout cardLayout = (CardLayout)this.contentPanel.getLayout();
        if (GUI_DISCONNECTED.equals(string) || GUI_CONNECTING.equals(string) || GUI_CONNECTED.equals(string) || GUI_DISCONNECTING.equals(string)) {
            this.currentPanel = (NXPanel)this.panels.get(string);
            this.currentPanel.activating();
            cardLayout.show(this.contentPanel, string);
            this.frame.getRootPane().setDefaultButton(this.currentPanel.getDefaultButton());
            this.currentPanel.activated();
        } else if ("666".equals(string)) {
            logger.fine("No debug operation defined...");
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void displayErrorMessage(String string) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "displayErrorMessage: " + string, new Throwable());
        } else {
            logger.info(string);
        }
        this.disconnectedPanel.setErrorText(string);
    }

    public ConnectingPanel getConnectingPanel() {
        return this.connectingPanel;
    }
}

