/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PasswordDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JPasswordField otpField;
    private JButton okButton;
    private JButton cancelButton;
    private boolean clickedOk = false;
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";

    public static String getPassword(Frame frame, String string, String string2) {
        PasswordDialog passwordDialog = new PasswordDialog(frame, string, string2);
        passwordDialog.setVisible(true);
        if (passwordDialog.clickedOk) {
            return String.valueOf(passwordDialog.otpField.getPassword());
        }
        return null;
    }

    private PasswordDialog(Frame frame, String string, String string2) {
        super(frame, string2, true);
        this.setResizable(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setContentPane(jPanel);
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.otpField = new JPasswordField();
        this.otpField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.otpField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 100.0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        jPanel.validate();
        this.pack();
        if (frame != null && (double)this.getWidth() < (double)frame.getWidth() * 0.9) {
            this.setSize((int)((double)frame.getWidth() * 0.9), this.getHeight());
            jPanel.validate();
        }
        this.setLocationRelativeTo(frame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (OK.equals(actionEvent.getActionCommand())) {
            this.clickedOk = true;
            this.setVisible(false);
        } else if (CANCEL.equals(actionEvent.getActionCommand())) {
            this.clickedOk = false;
            this.setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.passwordChanged(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.passwordChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.passwordChanged(documentEvent);
    }

    public void passwordChanged(DocumentEvent documentEvent) {
        char[] cArray = this.otpField.getPassword();
        this.okButton.setEnabled(cArray.length > 0);
        Arrays.fill(cArray, '\u0000');
    }
}

