/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import com.sonicwall.NetExtender;
import com.sonicwall.NetExtenderControl;
import com.sonicwall.gui.CertificateImportPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel cardPanel;
    private JList navBar;
    private CardLayout cardLayout;
    private JCheckBox autoReconnect;
    private JCheckBox uninstallOnExit;
    private JTextField mtu;
    private JCheckBox pppSync;
    private JRadioButton dnsOnlyRemote;
    private JRadioButton dnsOnlyLocal;
    private JRadioButton dnsPreferRemote;
    private final NetExtenderControl nxControl = NetExtenderControl.getInstance();
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final int MTU_DEFAULT_MAC = 1500;
    private static final int MTU_DEFAULT_LINUX = 1280;
    private static final int MTU_MIN = 128;
    private static final int MTU_MAX = 1500;
    private static int defaultMtu;
    private static final int NX_DNS_PREFER_REMOTE = 0;
    private static final int NX_DNS_ONLY_REMOTE = 1;
    private static final int NX_DNS_ONLY_LOCAL = 2;
    private static final Logger logger;

    public PreferencesDialog(Frame frame) {
        super(frame, "NetExtender Preferences", true);
        this.setSize(640, 460);
        this.setResizable(false);
        this.setContentPane(this.createContentContainer());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (OK.equals(actionEvent.getActionCommand())) {
            this.onOk();
        } else {
            this.onCancel();
        }
    }

    public void onOk() {
        if (this.uninstallOnExit.isEnabled()) {
            this.nxControl.setUninstallAfterExitPref(this.uninstallOnExit.isSelected());
        }
        this.nxControl.setAutoReconnectPref(this.autoReconnect.isSelected());
        if (this.mtu.isEnabled()) {
            int n = this.validateAndFixMtu();
            this.nxControl.setMtuPref(n);
        }
        if (!NetExtender.isMacMode()) {
            this.nxControl.setPppSyncPref(this.pppSync.isSelected());
        }
        if (this.dnsPreferRemote.isSelected()) {
            this.nxControl.setDnsModePref(0);
        } else if (this.dnsOnlyRemote.isSelected()) {
            this.nxControl.setDnsModePref(1);
        } else if (this.dnsOnlyLocal.isSelected()) {
            this.nxControl.setDnsModePref(2);
        }
        try {
            this.nxControl.saveProfiles();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Your preferences could not be saved to disk.\nThey may be different the next time you launch NetExtender.", "NetExtender Error", 0);
            logger.log(Level.SEVERE, "Error saving preferences", exception);
        }
        this.setVisible(false);
    }

    public void onCancel() {
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateFromPreferences();
        }
        super.setVisible(bl);
    }

    private void updateFromPreferences() {
        if (this.nxControl.isUninstallAfterExit()) {
            this.uninstallOnExit.setSelected(true);
            this.uninstallOnExit.setEnabled(false);
        } else {
            this.uninstallOnExit.setSelected(this.nxControl.isUninstallAfterExitPref());
            this.uninstallOnExit.setEnabled(true);
        }
        this.autoReconnect.setSelected(this.nxControl.isAutoReconnectPref());
        this.mtu.setText(Integer.toString(this.nxControl.getMtuPref()));
        this.mtu.setEnabled(!this.nxControl.isConnected());
        this.pppSync.setSelected(this.nxControl.isPppSyncPref());
        switch (this.nxControl.getDnsModePref()) {
            case 0: {
                this.dnsPreferRemote.setSelected(true);
                break;
            }
            case 1: {
                this.dnsOnlyRemote.setSelected(true);
                break;
            }
            case 2: {
                this.dnsOnlyLocal.setSelected(true);
            }
        }
        this.dnsPreferRemote.setEnabled(!this.nxControl.isConnected());
        this.dnsOnlyRemote.setEnabled(!this.nxControl.isConnected());
        this.dnsOnlyLocal.setEnabled(!this.nxControl.isConnected());
    }

    private Container createContentContainer() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add(this.createNavBar(), "West");
        jPanel.add(this.createButtonPanel(), "South");
        jPanel.add(this.createCardPanel(), "Center");
        return jPanel;
    }

    private Component createNavBar() {
        this.navBar = new JList<String>(new String[]{"Settings", "Advanced", "Certificate"});
        this.navBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.navBar.setSelectedIndex(0);
        this.navBar.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PreferencesDialog.this.cardLayout.show(PreferencesDialog.this.cardPanel, (String)PreferencesDialog.this.navBar.getSelectedValue());
                }
            }
        });
        return this.navBar;
    }

    private Component createButtonPanel() {
        JButton jButton = new JButton("OK");
        jButton.setActionCommand(OK);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand(CANCEL);
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        this.getRootPane().registerKeyboardAction(this, CANCEL, KeyStroke.getKeyStroke(27, 0), 2);
        return jPanel;
    }

    private Component createCardPanel() {
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add(this.createSettingsPanel(), "Settings");
        this.cardPanel.add(this.createAdvancedPanel(), "Advanced");
        this.cardPanel.add((Component)new CertificateImportPanel(this), "Certificate");
        return this.cardPanel;
    }

    private Component createSettingsPanel() {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Settings"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.autoReconnect = new JCheckBox("Automatically reconnect when the connection is terminated");
        this.uninstallOnExit = new JCheckBox("Uninstall NetExtender automatically");
        box.add(new JLabel("When I'm using NetExtender:"));
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(Box.createRigidArea(new Dimension(30, 0)));
        box2.add(this.autoReconnect);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(new JLabel("When I exit NetExtender:"));
        box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(Box.createRigidArea(new Dimension(30, 0)));
        box2.add(this.uninstallOnExit);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(new JLabel("DNS servers:"));
        this.dnsPreferRemote = new JRadioButton("Try remote DNS first, then try local");
        this.dnsOnlyRemote = new JRadioButton("Only use remote DNS servers");
        this.dnsOnlyLocal = new JRadioButton("Only use local DNS servers");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dnsPreferRemote);
        buttonGroup.add(this.dnsOnlyRemote);
        buttonGroup.add(this.dnsOnlyLocal);
        Box box3 = Box.createVerticalBox();
        box3.add(this.dnsPreferRemote);
        box3.add(this.dnsOnlyRemote);
        box3.add(this.dnsOnlyLocal);
        box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(Box.createRigidArea(new Dimension(30, 0)));
        box2.add(box3);
        box.add(box2);
        return box;
    }

    private int validateAndFixMtu() {
        try {
            int n = Integer.parseInt(this.mtu.getText());
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            if (n < 128) {
                n = 128;
                this.mtu.setText(String.valueOf(n));
            } else if (n > 1500) {
                n = 1500;
                this.mtu.setText(String.valueOf(n));
            }
            return n;
        }
        catch (Exception exception) {
            this.mtu.setText(String.valueOf(defaultMtu));
            return defaultMtu;
        }
    }

    private Component createAdvancedPanel() {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Advanced"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.mtu = new JTextField();
        this.mtu.setMaximumSize(new Dimension(60, 30));
        this.mtu.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PreferencesDialog.this.validateAndFixMtu();
            }
        });
        String string = "[128 - 1500]; default " + defaultMtu + ". IPv6 requires " + 1280 + " or higher.";
        this.mtu.setToolTipText(string);
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(new JLabel("MTU:"));
        box2.add(this.mtu);
        box.add(box2);
        this.pppSync = new JCheckBox("PPP sync mode");
        if (!NetExtender.isMacMode()) {
            box.add(this.pppSync);
        }
        return box;
    }

    void setMaximumSize(Component component, int n, int n2) {
        Dimension dimension = component.getMaximumSize();
        if (n > 0) {
            dimension.width = n;
        }
        if (n2 > 0) {
            dimension.height = n2;
        }
        component.setMaximumSize(dimension);
    }

    static {
        logger = Logger.getLogger(PreferencesDialog.class.getName());
        defaultMtu = NetExtender.isMacMode() ? 1500 : 1280;
    }
}

