/*
 * Decompiled with CFR 0.152.
 */
package com.sonicwall.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RsaNewPinDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JPasswordField pin1;
    private JPasswordField pin2;
    private JButton okButton;
    private JButton cancelButton;
    private boolean clickedOk = false;
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";

    public static String getNewPin(Frame frame) {
        return RsaNewPinDialog.getNewPin(frame, "A new PIN number is required.");
    }

    public static String getNewPin(Frame frame, String string) {
        RsaNewPinDialog rsaNewPinDialog = new RsaNewPinDialog(frame, string);
        rsaNewPinDialog.setVisible(true);
        if (rsaNewPinDialog.clickedOk) {
            return String.valueOf(rsaNewPinDialog.pin1.getPassword());
        }
        return null;
    }

    private RsaNewPinDialog(Frame frame, String string) {
        super(frame, "New PIN", true);
        this.setResizable(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setContentPane(jPanel);
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Enter new PIN:"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel("Re-enter new PIN:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.pin1 = new JPasswordField();
        this.pin1.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.pin1, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.pin2 = new JPasswordField();
        this.pin2.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.pin2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        jPanel.validate();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (OK.equals(actionEvent.getActionCommand())) {
            this.clickedOk = true;
            this.setVisible(false);
        } else if (CANCEL.equals(actionEvent.getActionCommand())) {
            this.clickedOk = false;
            this.setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.pinChanged(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.pinChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.pinChanged(documentEvent);
    }

    public void pinChanged(DocumentEvent documentEvent) {
        char[] cArray = this.pin1.getPassword();
        char[] cArray2 = this.pin2.getPassword();
        this.okButton.setEnabled(cArray.length > 0 && cArray2.length > 0 && Arrays.equals(cArray, cArray2));
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(cArray2, '\u0000');
    }
}

